@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sagemaker.kotlin.inputs

import com.pulumi.aws.sagemaker.inputs.DataQualityJobDefinitionDataQualityJobInputArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property batchTransformInput Input object for the batch transform job. Fields are documented below.
 * @property endpointInput Input object for the endpoint. Fields are documented below.
 */
public data class DataQualityJobDefinitionDataQualityJobInputArgs(
    public val batchTransformInput:
    Output<DataQualityJobDefinitionDataQualityJobInputBatchTransformInputArgs>? = null,
    public val endpointInput: Output<DataQualityJobDefinitionDataQualityJobInputEndpointInputArgs>? =
        null,
) :
    ConvertibleToJava<com.pulumi.aws.sagemaker.inputs.DataQualityJobDefinitionDataQualityJobInputArgs> {
    override fun toJava():
        com.pulumi.aws.sagemaker.inputs.DataQualityJobDefinitionDataQualityJobInputArgs =
        com.pulumi.aws.sagemaker.inputs.DataQualityJobDefinitionDataQualityJobInputArgs.builder()
            .batchTransformInput(
                batchTransformInput?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .endpointInput(endpointInput?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [DataQualityJobDefinitionDataQualityJobInputArgs].
 */
@PulumiTagMarker
public class DataQualityJobDefinitionDataQualityJobInputArgsBuilder internal constructor() {
    private var batchTransformInput:
        Output<DataQualityJobDefinitionDataQualityJobInputBatchTransformInputArgs>? = null

    private var endpointInput: Output<DataQualityJobDefinitionDataQualityJobInputEndpointInputArgs>? =
        null

    /**
     * @param value Input object for the batch transform job. Fields are documented below.
     */
    @JvmName("cyappkhvakijnjwa")
    public suspend
    fun batchTransformInput(`value`: Output<DataQualityJobDefinitionDataQualityJobInputBatchTransformInputArgs>) {
        this.batchTransformInput = value
    }

    /**
     * @param value Input object for the endpoint. Fields are documented below.
     */
    @JvmName("mfvxlpabtoqymrcc")
    public suspend
    fun endpointInput(`value`: Output<DataQualityJobDefinitionDataQualityJobInputEndpointInputArgs>) {
        this.endpointInput = value
    }

    /**
     * @param value Input object for the batch transform job. Fields are documented below.
     */
    @JvmName("hrqdprkqigfcoqtj")
    public suspend
    fun batchTransformInput(`value`: DataQualityJobDefinitionDataQualityJobInputBatchTransformInputArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.batchTransformInput = mapped
    }

    /**
     * @param argument Input object for the batch transform job. Fields are documented below.
     */
    @JvmName("dvrecjtcjbicjoqt")
    public suspend
    fun batchTransformInput(argument: suspend DataQualityJobDefinitionDataQualityJobInputBatchTransformInputArgsBuilder.() -> Unit) {
        val toBeMapped =
            DataQualityJobDefinitionDataQualityJobInputBatchTransformInputArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.batchTransformInput = mapped
    }

    /**
     * @param value Input object for the endpoint. Fields are documented below.
     */
    @JvmName("jfvdieffldgynell")
    public suspend
    fun endpointInput(`value`: DataQualityJobDefinitionDataQualityJobInputEndpointInputArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.endpointInput = mapped
    }

    /**
     * @param argument Input object for the endpoint. Fields are documented below.
     */
    @JvmName("uavluqvxmtvxchxs")
    public suspend
    fun endpointInput(argument: suspend DataQualityJobDefinitionDataQualityJobInputEndpointInputArgsBuilder.() -> Unit) {
        val toBeMapped =
            DataQualityJobDefinitionDataQualityJobInputEndpointInputArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.endpointInput = mapped
    }

    internal fun build(): DataQualityJobDefinitionDataQualityJobInputArgs =
        DataQualityJobDefinitionDataQualityJobInputArgs(
            batchTransformInput = batchTransformInput,
            endpointInput = endpointInput,
        )
}
