@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sagemaker.kotlin.inputs

import com.pulumi.aws.sagemaker.inputs.DataQualityJobDefinitionDataQualityJobInputEndpointInputArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property endpointName An endpoint in customer's account which has `data_capture_config` enabled.
 * @property localPath Path to the filesystem where the endpoint data is available to the container. Defaults to `/opt/ml/processing/input`.
 * @property s3DataDistributionType Whether input data distributed in Amazon S3 is fully replicated or sharded by an S3 key. Defaults to `FullyReplicated`. Valid values are `FullyReplicated` or `ShardedByS3Key`
 * @property s3InputMode Whether the `Pipe` or `File` is used as the input mode for transferring data for the monitoring job. `Pipe` mode is recommended for large datasets. `File` mode is useful for small files that fit in memory. Defaults to `File`.  Valid values are `Pipe` or `File`
 */
public data class DataQualityJobDefinitionDataQualityJobInputEndpointInputArgs(
    public val endpointName: Output<String>,
    public val localPath: Output<String>? = null,
    public val s3DataDistributionType: Output<String>? = null,
    public val s3InputMode: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.sagemaker.inputs.DataQualityJobDefinitionDataQualityJobInputEndpointInputArgs> {
    override fun toJava():
        com.pulumi.aws.sagemaker.inputs.DataQualityJobDefinitionDataQualityJobInputEndpointInputArgs =
        com.pulumi.aws.sagemaker.inputs.DataQualityJobDefinitionDataQualityJobInputEndpointInputArgs.builder()
            .endpointName(endpointName.applyValue({ args0 -> args0 }))
            .localPath(localPath?.applyValue({ args0 -> args0 }))
            .s3DataDistributionType(s3DataDistributionType?.applyValue({ args0 -> args0 }))
            .s3InputMode(s3InputMode?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DataQualityJobDefinitionDataQualityJobInputEndpointInputArgs].
 */
@PulumiTagMarker
public class DataQualityJobDefinitionDataQualityJobInputEndpointInputArgsBuilder internal
constructor() {
    private var endpointName: Output<String>? = null

    private var localPath: Output<String>? = null

    private var s3DataDistributionType: Output<String>? = null

    private var s3InputMode: Output<String>? = null

    /**
     * @param value An endpoint in customer's account which has `data_capture_config` enabled.
     */
    @JvmName("egyswrdnvjnljvvi")
    public suspend fun endpointName(`value`: Output<String>) {
        this.endpointName = value
    }

    /**
     * @param value Path to the filesystem where the endpoint data is available to the container. Defaults to `/opt/ml/processing/input`.
     */
    @JvmName("dkbcnqdnfsgvqwqd")
    public suspend fun localPath(`value`: Output<String>) {
        this.localPath = value
    }

    /**
     * @param value Whether input data distributed in Amazon S3 is fully replicated or sharded by an S3 key. Defaults to `FullyReplicated`. Valid values are `FullyReplicated` or `ShardedByS3Key`
     */
    @JvmName("qrrqsqouomvymsdr")
    public suspend fun s3DataDistributionType(`value`: Output<String>) {
        this.s3DataDistributionType = value
    }

    /**
     * @param value Whether the `Pipe` or `File` is used as the input mode for transferring data for the monitoring job. `Pipe` mode is recommended for large datasets. `File` mode is useful for small files that fit in memory. Defaults to `File`.  Valid values are `Pipe` or `File`
     */
    @JvmName("caasovsaishuxovk")
    public suspend fun s3InputMode(`value`: Output<String>) {
        this.s3InputMode = value
    }

    /**
     * @param value An endpoint in customer's account which has `data_capture_config` enabled.
     */
    @JvmName("wwyswqsklkokgsxx")
    public suspend fun endpointName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.endpointName = mapped
    }

    /**
     * @param value Path to the filesystem where the endpoint data is available to the container. Defaults to `/opt/ml/processing/input`.
     */
    @JvmName("oertbpdmfdlnevbe")
    public suspend fun localPath(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.localPath = mapped
    }

    /**
     * @param value Whether input data distributed in Amazon S3 is fully replicated or sharded by an S3 key. Defaults to `FullyReplicated`. Valid values are `FullyReplicated` or `ShardedByS3Key`
     */
    @JvmName("xbplbhviislcuskc")
    public suspend fun s3DataDistributionType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.s3DataDistributionType = mapped
    }

    /**
     * @param value Whether the `Pipe` or `File` is used as the input mode for transferring data for the monitoring job. `Pipe` mode is recommended for large datasets. `File` mode is useful for small files that fit in memory. Defaults to `File`.  Valid values are `Pipe` or `File`
     */
    @JvmName("iqvaujojwrpbtgea")
    public suspend fun s3InputMode(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.s3InputMode = mapped
    }

    internal fun build(): DataQualityJobDefinitionDataQualityJobInputEndpointInputArgs =
        DataQualityJobDefinitionDataQualityJobInputEndpointInputArgs(
            endpointName = endpointName ?: throw PulumiNullFieldException("endpointName"),
            localPath = localPath,
            s3DataDistributionType = s3DataDistributionType,
            s3InputMode = s3InputMode,
        )
}
