@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sagemaker.kotlin.inputs

import com.pulumi.aws.sagemaker.inputs.DataQualityJobDefinitionDataQualityJobOutputConfigMonitoringOutputsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property s3Output The Amazon S3 storage location where the results of a monitoring job are saved. Fields are documented below.
 */
public data class DataQualityJobDefinitionDataQualityJobOutputConfigMonitoringOutputsArgs(
    public val s3Output:
    Output<DataQualityJobDefinitionDataQualityJobOutputConfigMonitoringOutputsS3OutputArgs>,
) :
    ConvertibleToJava<com.pulumi.aws.sagemaker.inputs.DataQualityJobDefinitionDataQualityJobOutputConfigMonitoringOutputsArgs> {
    override fun toJava():
        com.pulumi.aws.sagemaker.inputs.DataQualityJobDefinitionDataQualityJobOutputConfigMonitoringOutputsArgs =
        com.pulumi.aws.sagemaker.inputs.DataQualityJobDefinitionDataQualityJobOutputConfigMonitoringOutputsArgs.builder()
            .s3Output(s3Output.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [DataQualityJobDefinitionDataQualityJobOutputConfigMonitoringOutputsArgs].
 */
@PulumiTagMarker
public class DataQualityJobDefinitionDataQualityJobOutputConfigMonitoringOutputsArgsBuilder internal
constructor() {
    private var s3Output:
        Output<DataQualityJobDefinitionDataQualityJobOutputConfigMonitoringOutputsS3OutputArgs>? =
        null

    /**
     * @param value The Amazon S3 storage location where the results of a monitoring job are saved. Fields are documented below.
     */
    @JvmName("vppwihxqxfrggjgf")
    public suspend
    fun s3Output(`value`: Output<DataQualityJobDefinitionDataQualityJobOutputConfigMonitoringOutputsS3OutputArgs>) {
        this.s3Output = value
    }

    /**
     * @param value The Amazon S3 storage location where the results of a monitoring job are saved. Fields are documented below.
     */
    @JvmName("sspeqrvjhvpwpxle")
    public suspend
    fun s3Output(`value`: DataQualityJobDefinitionDataQualityJobOutputConfigMonitoringOutputsS3OutputArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.s3Output = mapped
    }

    /**
     * @param argument The Amazon S3 storage location where the results of a monitoring job are saved. Fields are documented below.
     */
    @JvmName("mdoltymwhmdiytge")
    public suspend
    fun s3Output(argument: suspend DataQualityJobDefinitionDataQualityJobOutputConfigMonitoringOutputsS3OutputArgsBuilder.() -> Unit) {
        val toBeMapped =
            DataQualityJobDefinitionDataQualityJobOutputConfigMonitoringOutputsS3OutputArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.s3Output = mapped
    }

    internal fun build(): DataQualityJobDefinitionDataQualityJobOutputConfigMonitoringOutputsArgs =
        DataQualityJobDefinitionDataQualityJobOutputConfigMonitoringOutputsArgs(
            s3Output = s3Output ?: throw PulumiNullFieldException("s3Output"),
        )
}
