@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sagemaker.kotlin.inputs

import com.pulumi.aws.sagemaker.inputs.DataQualityJobDefinitionJobResourcesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property clusterConfig The configuration for the cluster resources used to run the processing job. Fields are documented below.
 */
public data class DataQualityJobDefinitionJobResourcesArgs(
    public val clusterConfig: Output<DataQualityJobDefinitionJobResourcesClusterConfigArgs>,
) : ConvertibleToJava<com.pulumi.aws.sagemaker.inputs.DataQualityJobDefinitionJobResourcesArgs> {
    override fun toJava(): com.pulumi.aws.sagemaker.inputs.DataQualityJobDefinitionJobResourcesArgs =
        com.pulumi.aws.sagemaker.inputs.DataQualityJobDefinitionJobResourcesArgs.builder()
            .clusterConfig(clusterConfig.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [DataQualityJobDefinitionJobResourcesArgs].
 */
@PulumiTagMarker
public class DataQualityJobDefinitionJobResourcesArgsBuilder internal constructor() {
    private var clusterConfig: Output<DataQualityJobDefinitionJobResourcesClusterConfigArgs>? = null

    /**
     * @param value The configuration for the cluster resources used to run the processing job. Fields are documented below.
     */
    @JvmName("olgvtwslkiuchdnm")
    public suspend
    fun clusterConfig(`value`: Output<DataQualityJobDefinitionJobResourcesClusterConfigArgs>) {
        this.clusterConfig = value
    }

    /**
     * @param value The configuration for the cluster resources used to run the processing job. Fields are documented below.
     */
    @JvmName("nkpbkjnudsgvnbud")
    public suspend fun clusterConfig(`value`: DataQualityJobDefinitionJobResourcesClusterConfigArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.clusterConfig = mapped
    }

    /**
     * @param argument The configuration for the cluster resources used to run the processing job. Fields are documented below.
     */
    @JvmName("ikycksdhyrnmaidr")
    public suspend
    fun clusterConfig(argument: suspend DataQualityJobDefinitionJobResourcesClusterConfigArgsBuilder.() -> Unit) {
        val toBeMapped = DataQualityJobDefinitionJobResourcesClusterConfigArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.clusterConfig = mapped
    }

    internal fun build(): DataQualityJobDefinitionJobResourcesArgs =
        DataQualityJobDefinitionJobResourcesArgs(
            clusterConfig = clusterConfig ?: throw PulumiNullFieldException("clusterConfig"),
        )
}
