@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sagemaker.kotlin.inputs

import com.pulumi.aws.sagemaker.inputs.DataQualityJobDefinitionJobResourcesClusterConfigArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property instanceCount The number of ML compute instances to use in the model monitoring job. For distributed processing jobs, specify a value greater than 1.
 * @property instanceType The ML compute instance type for the processing job.
 * @property volumeKmsKeyId The AWS Key Management Service (AWS KMS) key that Amazon SageMaker uses to encrypt data on the storage volume attached to the ML compute instance(s) that run the model monitoring job.
 * @property volumeSizeInGb The size of the ML storage volume, in gigabytes, that you want to provision. You must specify sufficient ML storage for your scenario.
 */
public data class DataQualityJobDefinitionJobResourcesClusterConfigArgs(
    public val instanceCount: Output<Int>,
    public val instanceType: Output<String>,
    public val volumeKmsKeyId: Output<String>? = null,
    public val volumeSizeInGb: Output<Int>,
) :
    ConvertibleToJava<com.pulumi.aws.sagemaker.inputs.DataQualityJobDefinitionJobResourcesClusterConfigArgs> {
    override fun toJava():
        com.pulumi.aws.sagemaker.inputs.DataQualityJobDefinitionJobResourcesClusterConfigArgs =
        com.pulumi.aws.sagemaker.inputs.DataQualityJobDefinitionJobResourcesClusterConfigArgs.builder()
            .instanceCount(instanceCount.applyValue({ args0 -> args0 }))
            .instanceType(instanceType.applyValue({ args0 -> args0 }))
            .volumeKmsKeyId(volumeKmsKeyId?.applyValue({ args0 -> args0 }))
            .volumeSizeInGb(volumeSizeInGb.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DataQualityJobDefinitionJobResourcesClusterConfigArgs].
 */
@PulumiTagMarker
public class DataQualityJobDefinitionJobResourcesClusterConfigArgsBuilder internal constructor() {
    private var instanceCount: Output<Int>? = null

    private var instanceType: Output<String>? = null

    private var volumeKmsKeyId: Output<String>? = null

    private var volumeSizeInGb: Output<Int>? = null

    /**
     * @param value The number of ML compute instances to use in the model monitoring job. For distributed processing jobs, specify a value greater than 1.
     */
    @JvmName("kxeuqgtepthoboex")
    public suspend fun instanceCount(`value`: Output<Int>) {
        this.instanceCount = value
    }

    /**
     * @param value The ML compute instance type for the processing job.
     */
    @JvmName("vkbrsscwxetyymjs")
    public suspend fun instanceType(`value`: Output<String>) {
        this.instanceType = value
    }

    /**
     * @param value The AWS Key Management Service (AWS KMS) key that Amazon SageMaker uses to encrypt data on the storage volume attached to the ML compute instance(s) that run the model monitoring job.
     */
    @JvmName("xhblcfnqaliyxqnj")
    public suspend fun volumeKmsKeyId(`value`: Output<String>) {
        this.volumeKmsKeyId = value
    }

    /**
     * @param value The size of the ML storage volume, in gigabytes, that you want to provision. You must specify sufficient ML storage for your scenario.
     */
    @JvmName("uvianpvcdsfiagas")
    public suspend fun volumeSizeInGb(`value`: Output<Int>) {
        this.volumeSizeInGb = value
    }

    /**
     * @param value The number of ML compute instances to use in the model monitoring job. For distributed processing jobs, specify a value greater than 1.
     */
    @JvmName("uqiftrqlahceyeef")
    public suspend fun instanceCount(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.instanceCount = mapped
    }

    /**
     * @param value The ML compute instance type for the processing job.
     */
    @JvmName("cfkghlduolahqwmq")
    public suspend fun instanceType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.instanceType = mapped
    }

    /**
     * @param value The AWS Key Management Service (AWS KMS) key that Amazon SageMaker uses to encrypt data on the storage volume attached to the ML compute instance(s) that run the model monitoring job.
     */
    @JvmName("kwnbdqjsmmebndey")
    public suspend fun volumeKmsKeyId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.volumeKmsKeyId = mapped
    }

    /**
     * @param value The size of the ML storage volume, in gigabytes, that you want to provision. You must specify sufficient ML storage for your scenario.
     */
    @JvmName("wcoxmodttnatnsuh")
    public suspend fun volumeSizeInGb(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.volumeSizeInGb = mapped
    }

    internal fun build(): DataQualityJobDefinitionJobResourcesClusterConfigArgs =
        DataQualityJobDefinitionJobResourcesClusterConfigArgs(
            instanceCount = instanceCount ?: throw PulumiNullFieldException("instanceCount"),
            instanceType = instanceType ?: throw PulumiNullFieldException("instanceType"),
            volumeKmsKeyId = volumeKmsKeyId,
            volumeSizeInGb = volumeSizeInGb ?: throw PulumiNullFieldException("volumeSizeInGb"),
        )
}
