@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sagemaker.kotlin.inputs

import com.pulumi.aws.sagemaker.inputs.DataQualityJobDefinitionNetworkConfigArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property enableInterContainerTrafficEncryption Whether to encrypt all communications between the instances used for the monitoring jobs. Choose `true` to encrypt communications. Encryption provides greater security for distributed jobs, but the processing might take longer.
 * @property enableNetworkIsolation Whether to allow inbound and outbound network calls to and from the containers used for the monitoring job.
 * @property vpcConfig Specifies a VPC that your training jobs and hosted models have access to. Control access to and from your training and model containers by configuring the VPC. Fields are documented below.
 */
public data class DataQualityJobDefinitionNetworkConfigArgs(
    public val enableInterContainerTrafficEncryption: Output<Boolean>? = null,
    public val enableNetworkIsolation: Output<Boolean>? = null,
    public val vpcConfig: Output<DataQualityJobDefinitionNetworkConfigVpcConfigArgs>? = null,
) : ConvertibleToJava<com.pulumi.aws.sagemaker.inputs.DataQualityJobDefinitionNetworkConfigArgs> {
    override fun toJava(): com.pulumi.aws.sagemaker.inputs.DataQualityJobDefinitionNetworkConfigArgs =
        com.pulumi.aws.sagemaker.inputs.DataQualityJobDefinitionNetworkConfigArgs.builder()
            .enableInterContainerTrafficEncryption(
                enableInterContainerTrafficEncryption?.applyValue({ args0 ->
                    args0
                }),
            )
            .enableNetworkIsolation(enableNetworkIsolation?.applyValue({ args0 -> args0 }))
            .vpcConfig(vpcConfig?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [DataQualityJobDefinitionNetworkConfigArgs].
 */
@PulumiTagMarker
public class DataQualityJobDefinitionNetworkConfigArgsBuilder internal constructor() {
    private var enableInterContainerTrafficEncryption: Output<Boolean>? = null

    private var enableNetworkIsolation: Output<Boolean>? = null

    private var vpcConfig: Output<DataQualityJobDefinitionNetworkConfigVpcConfigArgs>? = null

    /**
     * @param value Whether to encrypt all communications between the instances used for the monitoring jobs. Choose `true` to encrypt communications. Encryption provides greater security for distributed jobs, but the processing might take longer.
     */
    @JvmName("eyduuxnrfcocivyt")
    public suspend fun enableInterContainerTrafficEncryption(`value`: Output<Boolean>) {
        this.enableInterContainerTrafficEncryption = value
    }

    /**
     * @param value Whether to allow inbound and outbound network calls to and from the containers used for the monitoring job.
     */
    @JvmName("sqkddpjfcmjbsvph")
    public suspend fun enableNetworkIsolation(`value`: Output<Boolean>) {
        this.enableNetworkIsolation = value
    }

    /**
     * @param value Specifies a VPC that your training jobs and hosted models have access to. Control access to and from your training and model containers by configuring the VPC. Fields are documented below.
     */
    @JvmName("ngosvcpqrbosbiqb")
    public suspend
    fun vpcConfig(`value`: Output<DataQualityJobDefinitionNetworkConfigVpcConfigArgs>) {
        this.vpcConfig = value
    }

    /**
     * @param value Whether to encrypt all communications between the instances used for the monitoring jobs. Choose `true` to encrypt communications. Encryption provides greater security for distributed jobs, but the processing might take longer.
     */
    @JvmName("mqhggcjyhliqwnsq")
    public suspend fun enableInterContainerTrafficEncryption(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enableInterContainerTrafficEncryption = mapped
    }

    /**
     * @param value Whether to allow inbound and outbound network calls to and from the containers used for the monitoring job.
     */
    @JvmName("jxkljtmlrvpgtcbc")
    public suspend fun enableNetworkIsolation(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enableNetworkIsolation = mapped
    }

    /**
     * @param value Specifies a VPC that your training jobs and hosted models have access to. Control access to and from your training and model containers by configuring the VPC. Fields are documented below.
     */
    @JvmName("qsvnnurkwofwsxwt")
    public suspend fun vpcConfig(`value`: DataQualityJobDefinitionNetworkConfigVpcConfigArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vpcConfig = mapped
    }

    /**
     * @param argument Specifies a VPC that your training jobs and hosted models have access to. Control access to and from your training and model containers by configuring the VPC. Fields are documented below.
     */
    @JvmName("sifbrdgctotkrttp")
    public suspend
    fun vpcConfig(argument: suspend DataQualityJobDefinitionNetworkConfigVpcConfigArgsBuilder.() -> Unit) {
        val toBeMapped = DataQualityJobDefinitionNetworkConfigVpcConfigArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.vpcConfig = mapped
    }

    internal fun build(): DataQualityJobDefinitionNetworkConfigArgs =
        DataQualityJobDefinitionNetworkConfigArgs(
            enableInterContainerTrafficEncryption = enableInterContainerTrafficEncryption,
            enableNetworkIsolation = enableNetworkIsolation,
            vpcConfig = vpcConfig,
        )
}
