@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sagemaker.kotlin.inputs

import com.pulumi.aws.sagemaker.inputs.DeviceDeviceArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property description A description for the device.
 * @property deviceName The name of the device.
 * @property iotThingName Amazon Web Services Internet of Things (IoT) object name.
 */
public data class DeviceDeviceArgs(
    public val description: Output<String>? = null,
    public val deviceName: Output<String>,
    public val iotThingName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.sagemaker.inputs.DeviceDeviceArgs> {
    override fun toJava(): com.pulumi.aws.sagemaker.inputs.DeviceDeviceArgs =
        com.pulumi.aws.sagemaker.inputs.DeviceDeviceArgs.builder()
            .description(description?.applyValue({ args0 -> args0 }))
            .deviceName(deviceName.applyValue({ args0 -> args0 }))
            .iotThingName(iotThingName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DeviceDeviceArgs].
 */
@PulumiTagMarker
public class DeviceDeviceArgsBuilder internal constructor() {
    private var description: Output<String>? = null

    private var deviceName: Output<String>? = null

    private var iotThingName: Output<String>? = null

    /**
     * @param value A description for the device.
     */
    @JvmName("dkbetqcnknlwekdj")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The name of the device.
     */
    @JvmName("fettdxvmnodgyiip")
    public suspend fun deviceName(`value`: Output<String>) {
        this.deviceName = value
    }

    /**
     * @param value Amazon Web Services Internet of Things (IoT) object name.
     */
    @JvmName("lcarwhhevlndedob")
    public suspend fun iotThingName(`value`: Output<String>) {
        this.iotThingName = value
    }

    /**
     * @param value A description for the device.
     */
    @JvmName("efjtnycipiokumbi")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The name of the device.
     */
    @JvmName("essowjxwaowgyana")
    public suspend fun deviceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.deviceName = mapped
    }

    /**
     * @param value Amazon Web Services Internet of Things (IoT) object name.
     */
    @JvmName("vrqopjtejlxjuhpu")
    public suspend fun iotThingName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.iotThingName = mapped
    }

    internal fun build(): DeviceDeviceArgs = DeviceDeviceArgs(
        description = description,
        deviceName = deviceName ?: throw PulumiNullFieldException("deviceName"),
        iotThingName = iotThingName,
    )
}
