@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sagemaker.kotlin.inputs

import com.pulumi.aws.sagemaker.inputs.DeviceFleetOutputConfigArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property kmsKeyId The AWS Key Management Service (AWS KMS) key that Amazon SageMaker uses to encrypt data on the storage volume after compilation job. If you don't provide a KMS key ID, Amazon SageMaker uses the default KMS key for Amazon S3 for your role's account.
 * @property s3OutputLocation The Amazon Simple Storage (S3) bucker URI.
 */
public data class DeviceFleetOutputConfigArgs(
    public val kmsKeyId: Output<String>? = null,
    public val s3OutputLocation: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.sagemaker.inputs.DeviceFleetOutputConfigArgs> {
    override fun toJava(): com.pulumi.aws.sagemaker.inputs.DeviceFleetOutputConfigArgs =
        com.pulumi.aws.sagemaker.inputs.DeviceFleetOutputConfigArgs.builder()
            .kmsKeyId(kmsKeyId?.applyValue({ args0 -> args0 }))
            .s3OutputLocation(s3OutputLocation.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DeviceFleetOutputConfigArgs].
 */
@PulumiTagMarker
public class DeviceFleetOutputConfigArgsBuilder internal constructor() {
    private var kmsKeyId: Output<String>? = null

    private var s3OutputLocation: Output<String>? = null

    /**
     * @param value The AWS Key Management Service (AWS KMS) key that Amazon SageMaker uses to encrypt data on the storage volume after compilation job. If you don't provide a KMS key ID, Amazon SageMaker uses the default KMS key for Amazon S3 for your role's account.
     */
    @JvmName("ujcswqaveawcxoud")
    public suspend fun kmsKeyId(`value`: Output<String>) {
        this.kmsKeyId = value
    }

    /**
     * @param value The Amazon Simple Storage (S3) bucker URI.
     */
    @JvmName("spqwifkvkeknmcgf")
    public suspend fun s3OutputLocation(`value`: Output<String>) {
        this.s3OutputLocation = value
    }

    /**
     * @param value The AWS Key Management Service (AWS KMS) key that Amazon SageMaker uses to encrypt data on the storage volume after compilation job. If you don't provide a KMS key ID, Amazon SageMaker uses the default KMS key for Amazon S3 for your role's account.
     */
    @JvmName("uljedvqhomjynqht")
    public suspend fun kmsKeyId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kmsKeyId = mapped
    }

    /**
     * @param value The Amazon Simple Storage (S3) bucker URI.
     */
    @JvmName("xyfqrhtjirtxtorn")
    public suspend fun s3OutputLocation(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.s3OutputLocation = mapped
    }

    internal fun build(): DeviceFleetOutputConfigArgs = DeviceFleetOutputConfigArgs(
        kmsKeyId = kmsKeyId,
        s3OutputLocation = s3OutputLocation ?: throw PulumiNullFieldException("s3OutputLocation"),
    )
}
