@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sagemaker.kotlin.inputs

import com.pulumi.aws.sagemaker.inputs.DomainDefaultSpaceSettingsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property executionRole The execution role for the space.
 * @property jupyterServerAppSettings The Jupyter server's app settings. See Jupyter Server App Settings below.
 * @property kernelGatewayAppSettings The kernel gateway app settings. See Kernel Gateway App Settings below.
 * @property securityGroups The security groups for the Amazon Virtual Private Cloud that the space uses for communication.
 */
public data class DomainDefaultSpaceSettingsArgs(
    public val executionRole: Output<String>,
    public val jupyterServerAppSettings:
    Output<DomainDefaultSpaceSettingsJupyterServerAppSettingsArgs>? = null,
    public val kernelGatewayAppSettings:
    Output<DomainDefaultSpaceSettingsKernelGatewayAppSettingsArgs>? = null,
    public val securityGroups: Output<List<String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.sagemaker.inputs.DomainDefaultSpaceSettingsArgs> {
    override fun toJava(): com.pulumi.aws.sagemaker.inputs.DomainDefaultSpaceSettingsArgs =
        com.pulumi.aws.sagemaker.inputs.DomainDefaultSpaceSettingsArgs.builder()
            .executionRole(executionRole.applyValue({ args0 -> args0 }))
            .jupyterServerAppSettings(
                jupyterServerAppSettings?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .kernelGatewayAppSettings(
                kernelGatewayAppSettings?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .securityGroups(securityGroups?.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [DomainDefaultSpaceSettingsArgs].
 */
@PulumiTagMarker
public class DomainDefaultSpaceSettingsArgsBuilder internal constructor() {
    private var executionRole: Output<String>? = null

    private var jupyterServerAppSettings:
        Output<DomainDefaultSpaceSettingsJupyterServerAppSettingsArgs>? = null

    private var kernelGatewayAppSettings:
        Output<DomainDefaultSpaceSettingsKernelGatewayAppSettingsArgs>? = null

    private var securityGroups: Output<List<String>>? = null

    /**
     * @param value The execution role for the space.
     */
    @JvmName("txqkpsdiffqqepqq")
    public suspend fun executionRole(`value`: Output<String>) {
        this.executionRole = value
    }

    /**
     * @param value The Jupyter server's app settings. See Jupyter Server App Settings below.
     */
    @JvmName("dghogvwvbavnhola")
    public suspend
    fun jupyterServerAppSettings(`value`: Output<DomainDefaultSpaceSettingsJupyterServerAppSettingsArgs>) {
        this.jupyterServerAppSettings = value
    }

    /**
     * @param value The kernel gateway app settings. See Kernel Gateway App Settings below.
     */
    @JvmName("gsfeoyoenpmhmtpi")
    public suspend
    fun kernelGatewayAppSettings(`value`: Output<DomainDefaultSpaceSettingsKernelGatewayAppSettingsArgs>) {
        this.kernelGatewayAppSettings = value
    }

    /**
     * @param value The security groups for the Amazon Virtual Private Cloud that the space uses for communication.
     */
    @JvmName("idpyrvvgmxpmrsid")
    public suspend fun securityGroups(`value`: Output<List<String>>) {
        this.securityGroups = value
    }

    @JvmName("cxootlpegrfkdsiv")
    public suspend fun securityGroups(vararg values: Output<String>) {
        this.securityGroups = Output.all(values.asList())
    }

    /**
     * @param values The security groups for the Amazon Virtual Private Cloud that the space uses for communication.
     */
    @JvmName("kaphkteqmwnldpcw")
    public suspend fun securityGroups(values: List<Output<String>>) {
        this.securityGroups = Output.all(values)
    }

    /**
     * @param value The execution role for the space.
     */
    @JvmName("igpqckpvcwfpsdrk")
    public suspend fun executionRole(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.executionRole = mapped
    }

    /**
     * @param value The Jupyter server's app settings. See Jupyter Server App Settings below.
     */
    @JvmName("rmumjckfaiymcjqw")
    public suspend
    fun jupyterServerAppSettings(`value`: DomainDefaultSpaceSettingsJupyterServerAppSettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.jupyterServerAppSettings = mapped
    }

    /**
     * @param argument The Jupyter server's app settings. See Jupyter Server App Settings below.
     */
    @JvmName("jypywrqfykqktrtp")
    public suspend
    fun jupyterServerAppSettings(argument: suspend DomainDefaultSpaceSettingsJupyterServerAppSettingsArgsBuilder.() -> Unit) {
        val toBeMapped = DomainDefaultSpaceSettingsJupyterServerAppSettingsArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.jupyterServerAppSettings = mapped
    }

    /**
     * @param value The kernel gateway app settings. See Kernel Gateway App Settings below.
     */
    @JvmName("yqftdwjcflxympeb")
    public suspend
    fun kernelGatewayAppSettings(`value`: DomainDefaultSpaceSettingsKernelGatewayAppSettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kernelGatewayAppSettings = mapped
    }

    /**
     * @param argument The kernel gateway app settings. See Kernel Gateway App Settings below.
     */
    @JvmName("hlwefffuysnmrkiq")
    public suspend
    fun kernelGatewayAppSettings(argument: suspend DomainDefaultSpaceSettingsKernelGatewayAppSettingsArgsBuilder.() -> Unit) {
        val toBeMapped = DomainDefaultSpaceSettingsKernelGatewayAppSettingsArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.kernelGatewayAppSettings = mapped
    }

    /**
     * @param value The security groups for the Amazon Virtual Private Cloud that the space uses for communication.
     */
    @JvmName("nykrwbmdsdacdcyh")
    public suspend fun securityGroups(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.securityGroups = mapped
    }

    /**
     * @param values The security groups for the Amazon Virtual Private Cloud that the space uses for communication.
     */
    @JvmName("vojiawdijtccofrm")
    public suspend fun securityGroups(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.securityGroups = mapped
    }

    internal fun build(): DomainDefaultSpaceSettingsArgs = DomainDefaultSpaceSettingsArgs(
        executionRole = executionRole ?: throw PulumiNullFieldException("executionRole"),
        jupyterServerAppSettings = jupyterServerAppSettings,
        kernelGatewayAppSettings = kernelGatewayAppSettings,
        securityGroups = securityGroups,
    )
}
