@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sagemaker.kotlin.inputs

import com.pulumi.aws.sagemaker.inputs.DomainDefaultSpaceSettingsKernelGatewayAppSettingsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property customImages A list of custom SageMaker images that are configured to run as a KernelGateway app. see Custom Image below.
 * @property defaultResourceSpec The default instance type and the Amazon Resource Name (ARN) of the SageMaker image created on the instance. see Default Resource Spec below.
 * @property lifecycleConfigArns The Amazon Resource Name (ARN) of the Lifecycle Configurations.
 */
public data class DomainDefaultSpaceSettingsKernelGatewayAppSettingsArgs(
    public val customImages:
    Output<List<DomainDefaultSpaceSettingsKernelGatewayAppSettingsCustomImageArgs>>? = null,
    public val defaultResourceSpec:
    Output<DomainDefaultSpaceSettingsKernelGatewayAppSettingsDefaultResourceSpecArgs>? = null,
    public val lifecycleConfigArns: Output<List<String>>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.sagemaker.inputs.DomainDefaultSpaceSettingsKernelGatewayAppSettingsArgs> {
    override fun toJava():
        com.pulumi.aws.sagemaker.inputs.DomainDefaultSpaceSettingsKernelGatewayAppSettingsArgs =
        com.pulumi.aws.sagemaker.inputs.DomainDefaultSpaceSettingsKernelGatewayAppSettingsArgs.builder()
            .customImages(
                customImages?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .defaultResourceSpec(
                defaultResourceSpec?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .lifecycleConfigArns(
                lifecycleConfigArns?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0
                    })
                }),
            ).build()
}

/**
 * Builder for [DomainDefaultSpaceSettingsKernelGatewayAppSettingsArgs].
 */
@PulumiTagMarker
public class DomainDefaultSpaceSettingsKernelGatewayAppSettingsArgsBuilder internal constructor() {
    private var customImages:
        Output<List<DomainDefaultSpaceSettingsKernelGatewayAppSettingsCustomImageArgs>>? = null

    private var defaultResourceSpec:
        Output<DomainDefaultSpaceSettingsKernelGatewayAppSettingsDefaultResourceSpecArgs>? = null

    private var lifecycleConfigArns: Output<List<String>>? = null

    /**
     * @param value A list of custom SageMaker images that are configured to run as a KernelGateway app. see Custom Image below.
     */
    @JvmName("qcgkqgjxgamhxyva")
    public suspend
    fun customImages(`value`: Output<List<DomainDefaultSpaceSettingsKernelGatewayAppSettingsCustomImageArgs>>) {
        this.customImages = value
    }

    @JvmName("nyokobtfrgcpchrk")
    public suspend fun customImages(
        vararg
        values: Output<DomainDefaultSpaceSettingsKernelGatewayAppSettingsCustomImageArgs>,
    ) {
        this.customImages = Output.all(values.asList())
    }

    /**
     * @param values A list of custom SageMaker images that are configured to run as a KernelGateway app. see Custom Image below.
     */
    @JvmName("gkauqjfjlebctcsm")
    public suspend
    fun customImages(values: List<Output<DomainDefaultSpaceSettingsKernelGatewayAppSettingsCustomImageArgs>>) {
        this.customImages = Output.all(values)
    }

    /**
     * @param value The default instance type and the Amazon Resource Name (ARN) of the SageMaker image created on the instance. see Default Resource Spec below.
     */
    @JvmName("hnkkttfgisndbanq")
    public suspend
    fun defaultResourceSpec(`value`: Output<DomainDefaultSpaceSettingsKernelGatewayAppSettingsDefaultResourceSpecArgs>) {
        this.defaultResourceSpec = value
    }

    /**
     * @param value The Amazon Resource Name (ARN) of the Lifecycle Configurations.
     */
    @JvmName("toelgtkoetdcvywv")
    public suspend fun lifecycleConfigArns(`value`: Output<List<String>>) {
        this.lifecycleConfigArns = value
    }

    @JvmName("midwcelkkctqppxv")
    public suspend fun lifecycleConfigArns(vararg values: Output<String>) {
        this.lifecycleConfigArns = Output.all(values.asList())
    }

    /**
     * @param values The Amazon Resource Name (ARN) of the Lifecycle Configurations.
     */
    @JvmName("ftjxflrcusymkijt")
    public suspend fun lifecycleConfigArns(values: List<Output<String>>) {
        this.lifecycleConfigArns = Output.all(values)
    }

    /**
     * @param value A list of custom SageMaker images that are configured to run as a KernelGateway app. see Custom Image below.
     */
    @JvmName("xwuoelyonhcnjwge")
    public suspend
    fun customImages(`value`: List<DomainDefaultSpaceSettingsKernelGatewayAppSettingsCustomImageArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.customImages = mapped
    }

    /**
     * @param argument A list of custom SageMaker images that are configured to run as a KernelGateway app. see Custom Image below.
     */
    @JvmName("twrncihvgroanpfe")
    public suspend
    fun customImages(argument: List<suspend DomainDefaultSpaceSettingsKernelGatewayAppSettingsCustomImageArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            DomainDefaultSpaceSettingsKernelGatewayAppSettingsCustomImageArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.customImages = mapped
    }

    /**
     * @param argument A list of custom SageMaker images that are configured to run as a KernelGateway app. see Custom Image below.
     */
    @JvmName("pxcmmcxrsfbqrbtq")
    public suspend fun customImages(
        vararg
        argument: suspend DomainDefaultSpaceSettingsKernelGatewayAppSettingsCustomImageArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            DomainDefaultSpaceSettingsKernelGatewayAppSettingsCustomImageArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.customImages = mapped
    }

    /**
     * @param argument A list of custom SageMaker images that are configured to run as a KernelGateway app. see Custom Image below.
     */
    @JvmName("vmwnkyknathpcxsv")
    public suspend
    fun customImages(argument: suspend DomainDefaultSpaceSettingsKernelGatewayAppSettingsCustomImageArgsBuilder.() -> Unit) {
        val toBeMapped =
            listOf(
                DomainDefaultSpaceSettingsKernelGatewayAppSettingsCustomImageArgsBuilder().applySuspend
                    { argument() }.build(),
            )
        val mapped = of(toBeMapped)
        this.customImages = mapped
    }

    /**
     * @param values A list of custom SageMaker images that are configured to run as a KernelGateway app. see Custom Image below.
     */
    @JvmName("jaxcbmhgyrgbsbrt")
    public suspend fun customImages(
        vararg
        values: DomainDefaultSpaceSettingsKernelGatewayAppSettingsCustomImageArgs,
    ) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.customImages = mapped
    }

    /**
     * @param value The default instance type and the Amazon Resource Name (ARN) of the SageMaker image created on the instance. see Default Resource Spec below.
     */
    @JvmName("sjmqfwpmuoiurmfg")
    public suspend
    fun defaultResourceSpec(`value`: DomainDefaultSpaceSettingsKernelGatewayAppSettingsDefaultResourceSpecArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.defaultResourceSpec = mapped
    }

    /**
     * @param argument The default instance type and the Amazon Resource Name (ARN) of the SageMaker image created on the instance. see Default Resource Spec below.
     */
    @JvmName("nmiaxwrdulnmokcv")
    public suspend
    fun defaultResourceSpec(argument: suspend DomainDefaultSpaceSettingsKernelGatewayAppSettingsDefaultResourceSpecArgsBuilder.() -> Unit) {
        val toBeMapped =
            DomainDefaultSpaceSettingsKernelGatewayAppSettingsDefaultResourceSpecArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.defaultResourceSpec = mapped
    }

    /**
     * @param value The Amazon Resource Name (ARN) of the Lifecycle Configurations.
     */
    @JvmName("rgqkwsblykmjocud")
    public suspend fun lifecycleConfigArns(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.lifecycleConfigArns = mapped
    }

    /**
     * @param values The Amazon Resource Name (ARN) of the Lifecycle Configurations.
     */
    @JvmName("fkntthavmudqxtlm")
    public suspend fun lifecycleConfigArns(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.lifecycleConfigArns = mapped
    }

    internal fun build(): DomainDefaultSpaceSettingsKernelGatewayAppSettingsArgs =
        DomainDefaultSpaceSettingsKernelGatewayAppSettingsArgs(
            customImages = customImages,
            defaultResourceSpec = defaultResourceSpec,
            lifecycleConfigArns = lifecycleConfigArns,
        )
}
