@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sagemaker.kotlin.inputs

import com.pulumi.aws.sagemaker.inputs.DomainDefaultUserSettingsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property canvasAppSettings The Canvas app settings. See Canvas App Settings below.
 * @property executionRole The execution role ARN for the user.
 * @property jupyterServerAppSettings The Jupyter server's app settings. See Jupyter Server App Settings below.
 * @property kernelGatewayAppSettings The kernel gateway app settings. See Kernel Gateway App Settings below.
 * @property rSessionAppSettings The RSession app settings. See RSession App Settings below.
 * @property rStudioServerProAppSettings A collection of settings that configure user interaction with the RStudioServerPro app. See RStudioServerProAppSettings below.
 * @property securityGroups A list of security group IDs that will be attached to the user.
 * @property sharingSettings The sharing settings. See Sharing Settings below.
 * @property tensorBoardAppSettings The TensorBoard app settings. See TensorBoard App Settings below.
 */
public data class DomainDefaultUserSettingsArgs(
    public val canvasAppSettings: Output<DomainDefaultUserSettingsCanvasAppSettingsArgs>? = null,
    public val executionRole: Output<String>,
    public val jupyterServerAppSettings:
    Output<DomainDefaultUserSettingsJupyterServerAppSettingsArgs>? = null,
    public val kernelGatewayAppSettings:
    Output<DomainDefaultUserSettingsKernelGatewayAppSettingsArgs>? = null,
    public val rSessionAppSettings: Output<DomainDefaultUserSettingsRSessionAppSettingsArgs>? = null,
    public val rStudioServerProAppSettings:
    Output<DomainDefaultUserSettingsRStudioServerProAppSettingsArgs>? = null,
    public val securityGroups: Output<List<String>>? = null,
    public val sharingSettings: Output<DomainDefaultUserSettingsSharingSettingsArgs>? = null,
    public val tensorBoardAppSettings: Output<DomainDefaultUserSettingsTensorBoardAppSettingsArgs>? =
        null,
) : ConvertibleToJava<com.pulumi.aws.sagemaker.inputs.DomainDefaultUserSettingsArgs> {
    override fun toJava(): com.pulumi.aws.sagemaker.inputs.DomainDefaultUserSettingsArgs =
        com.pulumi.aws.sagemaker.inputs.DomainDefaultUserSettingsArgs.builder()
            .canvasAppSettings(canvasAppSettings?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .executionRole(executionRole.applyValue({ args0 -> args0 }))
            .jupyterServerAppSettings(
                jupyterServerAppSettings?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .kernelGatewayAppSettings(
                kernelGatewayAppSettings?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .rSessionAppSettings(
                rSessionAppSettings?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .rStudioServerProAppSettings(
                rStudioServerProAppSettings?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .securityGroups(securityGroups?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .sharingSettings(sharingSettings?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .tensorBoardAppSettings(
                tensorBoardAppSettings?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [DomainDefaultUserSettingsArgs].
 */
@PulumiTagMarker
public class DomainDefaultUserSettingsArgsBuilder internal constructor() {
    private var canvasAppSettings: Output<DomainDefaultUserSettingsCanvasAppSettingsArgs>? = null

    private var executionRole: Output<String>? = null

    private var jupyterServerAppSettings:
        Output<DomainDefaultUserSettingsJupyterServerAppSettingsArgs>? = null

    private var kernelGatewayAppSettings:
        Output<DomainDefaultUserSettingsKernelGatewayAppSettingsArgs>? = null

    private var rSessionAppSettings: Output<DomainDefaultUserSettingsRSessionAppSettingsArgs>? = null

    private var rStudioServerProAppSettings:
        Output<DomainDefaultUserSettingsRStudioServerProAppSettingsArgs>? = null

    private var securityGroups: Output<List<String>>? = null

    private var sharingSettings: Output<DomainDefaultUserSettingsSharingSettingsArgs>? = null

    private var tensorBoardAppSettings: Output<DomainDefaultUserSettingsTensorBoardAppSettingsArgs>? =
        null

    /**
     * @param value The Canvas app settings. See Canvas App Settings below.
     */
    @JvmName("vemwwfknwyhrkfkq")
    public suspend
    fun canvasAppSettings(`value`: Output<DomainDefaultUserSettingsCanvasAppSettingsArgs>) {
        this.canvasAppSettings = value
    }

    /**
     * @param value The execution role ARN for the user.
     */
    @JvmName("vafdurkoenmnyclk")
    public suspend fun executionRole(`value`: Output<String>) {
        this.executionRole = value
    }

    /**
     * @param value The Jupyter server's app settings. See Jupyter Server App Settings below.
     */
    @JvmName("mxfbotascruskiiq")
    public suspend
    fun jupyterServerAppSettings(`value`: Output<DomainDefaultUserSettingsJupyterServerAppSettingsArgs>) {
        this.jupyterServerAppSettings = value
    }

    /**
     * @param value The kernel gateway app settings. See Kernel Gateway App Settings below.
     */
    @JvmName("kjrvwdiyvgdeqnsc")
    public suspend
    fun kernelGatewayAppSettings(`value`: Output<DomainDefaultUserSettingsKernelGatewayAppSettingsArgs>) {
        this.kernelGatewayAppSettings = value
    }

    /**
     * @param value The RSession app settings. See RSession App Settings below.
     */
    @JvmName("cswuklspgtxblgjr")
    public suspend
    fun rSessionAppSettings(`value`: Output<DomainDefaultUserSettingsRSessionAppSettingsArgs>) {
        this.rSessionAppSettings = value
    }

    /**
     * @param value A collection of settings that configure user interaction with the RStudioServerPro app. See RStudioServerProAppSettings below.
     */
    @JvmName("vhhmadlmophlsiuw")
    public suspend
    fun rStudioServerProAppSettings(`value`: Output<DomainDefaultUserSettingsRStudioServerProAppSettingsArgs>) {
        this.rStudioServerProAppSettings = value
    }

    /**
     * @param value A list of security group IDs that will be attached to the user.
     */
    @JvmName("apjravhygshdgynb")
    public suspend fun securityGroups(`value`: Output<List<String>>) {
        this.securityGroups = value
    }

    @JvmName("xflsyqoiubhdeftn")
    public suspend fun securityGroups(vararg values: Output<String>) {
        this.securityGroups = Output.all(values.asList())
    }

    /**
     * @param values A list of security group IDs that will be attached to the user.
     */
    @JvmName("sjqjxdkdqjijyjca")
    public suspend fun securityGroups(values: List<Output<String>>) {
        this.securityGroups = Output.all(values)
    }

    /**
     * @param value The sharing settings. See Sharing Settings below.
     */
    @JvmName("tovjqexremkqemle")
    public suspend
    fun sharingSettings(`value`: Output<DomainDefaultUserSettingsSharingSettingsArgs>) {
        this.sharingSettings = value
    }

    /**
     * @param value The TensorBoard app settings. See TensorBoard App Settings below.
     */
    @JvmName("txcpsjchievhmeox")
    public suspend
    fun tensorBoardAppSettings(`value`: Output<DomainDefaultUserSettingsTensorBoardAppSettingsArgs>) {
        this.tensorBoardAppSettings = value
    }

    /**
     * @param value The Canvas app settings. See Canvas App Settings below.
     */
    @JvmName("mdtlikwyyufkhega")
    public suspend fun canvasAppSettings(`value`: DomainDefaultUserSettingsCanvasAppSettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.canvasAppSettings = mapped
    }

    /**
     * @param argument The Canvas app settings. See Canvas App Settings below.
     */
    @JvmName("fomafrucgphuabbn")
    public suspend
    fun canvasAppSettings(argument: suspend DomainDefaultUserSettingsCanvasAppSettingsArgsBuilder.() -> Unit) {
        val toBeMapped = DomainDefaultUserSettingsCanvasAppSettingsArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.canvasAppSettings = mapped
    }

    /**
     * @param value The execution role ARN for the user.
     */
    @JvmName("mlautnuetfhoexpu")
    public suspend fun executionRole(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.executionRole = mapped
    }

    /**
     * @param value The Jupyter server's app settings. See Jupyter Server App Settings below.
     */
    @JvmName("letfomgqxkdwhjje")
    public suspend
    fun jupyterServerAppSettings(`value`: DomainDefaultUserSettingsJupyterServerAppSettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.jupyterServerAppSettings = mapped
    }

    /**
     * @param argument The Jupyter server's app settings. See Jupyter Server App Settings below.
     */
    @JvmName("cxukkoyeuqbwwccn")
    public suspend
    fun jupyterServerAppSettings(argument: suspend DomainDefaultUserSettingsJupyterServerAppSettingsArgsBuilder.() -> Unit) {
        val toBeMapped = DomainDefaultUserSettingsJupyterServerAppSettingsArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.jupyterServerAppSettings = mapped
    }

    /**
     * @param value The kernel gateway app settings. See Kernel Gateway App Settings below.
     */
    @JvmName("fpudyfsrjyaudpgl")
    public suspend
    fun kernelGatewayAppSettings(`value`: DomainDefaultUserSettingsKernelGatewayAppSettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kernelGatewayAppSettings = mapped
    }

    /**
     * @param argument The kernel gateway app settings. See Kernel Gateway App Settings below.
     */
    @JvmName("fvxvrwtrryijuweo")
    public suspend
    fun kernelGatewayAppSettings(argument: suspend DomainDefaultUserSettingsKernelGatewayAppSettingsArgsBuilder.() -> Unit) {
        val toBeMapped = DomainDefaultUserSettingsKernelGatewayAppSettingsArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.kernelGatewayAppSettings = mapped
    }

    /**
     * @param value The RSession app settings. See RSession App Settings below.
     */
    @JvmName("etwuhoebrmqlyokk")
    public suspend
    fun rSessionAppSettings(`value`: DomainDefaultUserSettingsRSessionAppSettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.rSessionAppSettings = mapped
    }

    /**
     * @param argument The RSession app settings. See RSession App Settings below.
     */
    @JvmName("kcnltuegxyhsbdvq")
    public suspend
    fun rSessionAppSettings(argument: suspend DomainDefaultUserSettingsRSessionAppSettingsArgsBuilder.() -> Unit) {
        val toBeMapped = DomainDefaultUserSettingsRSessionAppSettingsArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.rSessionAppSettings = mapped
    }

    /**
     * @param value A collection of settings that configure user interaction with the RStudioServerPro app. See RStudioServerProAppSettings below.
     */
    @JvmName("dfgeisxdoakybpjf")
    public suspend
    fun rStudioServerProAppSettings(`value`: DomainDefaultUserSettingsRStudioServerProAppSettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.rStudioServerProAppSettings = mapped
    }

    /**
     * @param argument A collection of settings that configure user interaction with the RStudioServerPro app. See RStudioServerProAppSettings below.
     */
    @JvmName("qypicssghevkibgg")
    public suspend
    fun rStudioServerProAppSettings(argument: suspend DomainDefaultUserSettingsRStudioServerProAppSettingsArgsBuilder.() -> Unit) {
        val toBeMapped = DomainDefaultUserSettingsRStudioServerProAppSettingsArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.rStudioServerProAppSettings = mapped
    }

    /**
     * @param value A list of security group IDs that will be attached to the user.
     */
    @JvmName("lkjacvlihkkygjil")
    public suspend fun securityGroups(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.securityGroups = mapped
    }

    /**
     * @param values A list of security group IDs that will be attached to the user.
     */
    @JvmName("kmykltjtlhdyxqrm")
    public suspend fun securityGroups(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.securityGroups = mapped
    }

    /**
     * @param value The sharing settings. See Sharing Settings below.
     */
    @JvmName("giocysswmrguynry")
    public suspend fun sharingSettings(`value`: DomainDefaultUserSettingsSharingSettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sharingSettings = mapped
    }

    /**
     * @param argument The sharing settings. See Sharing Settings below.
     */
    @JvmName("jrexgrhuvcwnvxar")
    public suspend
    fun sharingSettings(argument: suspend DomainDefaultUserSettingsSharingSettingsArgsBuilder.() -> Unit) {
        val toBeMapped = DomainDefaultUserSettingsSharingSettingsArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.sharingSettings = mapped
    }

    /**
     * @param value The TensorBoard app settings. See TensorBoard App Settings below.
     */
    @JvmName("jaiktytsiefohnkd")
    public suspend
    fun tensorBoardAppSettings(`value`: DomainDefaultUserSettingsTensorBoardAppSettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tensorBoardAppSettings = mapped
    }

    /**
     * @param argument The TensorBoard app settings. See TensorBoard App Settings below.
     */
    @JvmName("nupjnsdueuwprkwm")
    public suspend
    fun tensorBoardAppSettings(argument: suspend DomainDefaultUserSettingsTensorBoardAppSettingsArgsBuilder.() -> Unit) {
        val toBeMapped = DomainDefaultUserSettingsTensorBoardAppSettingsArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.tensorBoardAppSettings = mapped
    }

    internal fun build(): DomainDefaultUserSettingsArgs = DomainDefaultUserSettingsArgs(
        canvasAppSettings = canvasAppSettings,
        executionRole = executionRole ?: throw PulumiNullFieldException("executionRole"),
        jupyterServerAppSettings = jupyterServerAppSettings,
        kernelGatewayAppSettings = kernelGatewayAppSettings,
        rSessionAppSettings = rSessionAppSettings,
        rStudioServerProAppSettings = rStudioServerProAppSettings,
        securityGroups = securityGroups,
        sharingSettings = sharingSettings,
        tensorBoardAppSettings = tensorBoardAppSettings,
    )
}
