@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sagemaker.kotlin.inputs

import com.pulumi.aws.sagemaker.inputs.DomainDefaultUserSettingsCanvasAppSettingsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property directDeploySettings The model deployment settings for the SageMaker Canvas application. See Direct Deploy Settings below.
 * @property identityProviderOauthSettings The settings for connecting to an external data source with OAuth. See Identity Provider OAuth Settings below.
 * @property kendraSettings The settings for document querying. See Kendra Settings below.
 * @property modelRegisterSettings The model registry settings for the SageMaker Canvas application. See Model Register Settings below.
 * @property timeSeriesForecastingSettings Time series forecast settings for the Canvas app. See Time Series Forecasting Settings below.
 * @property workspaceSettings The workspace settings for the SageMaker Canvas application. See Workspace Settings below.
 */
public data class DomainDefaultUserSettingsCanvasAppSettingsArgs(
    public val directDeploySettings:
    Output<DomainDefaultUserSettingsCanvasAppSettingsDirectDeploySettingsArgs>? = null,
    public val identityProviderOauthSettings:
    Output<List<DomainDefaultUserSettingsCanvasAppSettingsIdentityProviderOauthSettingArgs>>? =
        null,
    public val kendraSettings: Output<DomainDefaultUserSettingsCanvasAppSettingsKendraSettingsArgs>? =
        null,
    public val modelRegisterSettings:
    Output<DomainDefaultUserSettingsCanvasAppSettingsModelRegisterSettingsArgs>? = null,
    public val timeSeriesForecastingSettings:
    Output<DomainDefaultUserSettingsCanvasAppSettingsTimeSeriesForecastingSettingsArgs>? = null,
    public val workspaceSettings:
    Output<DomainDefaultUserSettingsCanvasAppSettingsWorkspaceSettingsArgs>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.sagemaker.inputs.DomainDefaultUserSettingsCanvasAppSettingsArgs> {
    override fun toJava():
        com.pulumi.aws.sagemaker.inputs.DomainDefaultUserSettingsCanvasAppSettingsArgs =
        com.pulumi.aws.sagemaker.inputs.DomainDefaultUserSettingsCanvasAppSettingsArgs.builder()
            .directDeploySettings(
                directDeploySettings?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .identityProviderOauthSettings(
                identityProviderOauthSettings?.applyValue({ args0 ->
                    args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .kendraSettings(kendraSettings?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .modelRegisterSettings(
                modelRegisterSettings?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .timeSeriesForecastingSettings(
                timeSeriesForecastingSettings?.applyValue({ args0 ->
                    args0.let({ args0 -> args0.toJava() })
                }),
            )
            .workspaceSettings(
                workspaceSettings?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [DomainDefaultUserSettingsCanvasAppSettingsArgs].
 */
@PulumiTagMarker
public class DomainDefaultUserSettingsCanvasAppSettingsArgsBuilder internal constructor() {
    private var directDeploySettings:
        Output<DomainDefaultUserSettingsCanvasAppSettingsDirectDeploySettingsArgs>? = null

    private var identityProviderOauthSettings:
        Output<List<DomainDefaultUserSettingsCanvasAppSettingsIdentityProviderOauthSettingArgs>>? =
        null

    private var kendraSettings: Output<DomainDefaultUserSettingsCanvasAppSettingsKendraSettingsArgs>? =
        null

    private var modelRegisterSettings:
        Output<DomainDefaultUserSettingsCanvasAppSettingsModelRegisterSettingsArgs>? = null

    private var timeSeriesForecastingSettings:
        Output<DomainDefaultUserSettingsCanvasAppSettingsTimeSeriesForecastingSettingsArgs>? = null

    private var workspaceSettings:
        Output<DomainDefaultUserSettingsCanvasAppSettingsWorkspaceSettingsArgs>? = null

    /**
     * @param value The model deployment settings for the SageMaker Canvas application. See Direct Deploy Settings below.
     */
    @JvmName("fpfldckyvvcajdka")
    public suspend
    fun directDeploySettings(`value`: Output<DomainDefaultUserSettingsCanvasAppSettingsDirectDeploySettingsArgs>) {
        this.directDeploySettings = value
    }

    /**
     * @param value The settings for connecting to an external data source with OAuth. See Identity Provider OAuth Settings below.
     */
    @JvmName("ghvbyuofbqgrqput")
    public suspend
    fun identityProviderOauthSettings(`value`: Output<List<DomainDefaultUserSettingsCanvasAppSettingsIdentityProviderOauthSettingArgs>>) {
        this.identityProviderOauthSettings = value
    }

    @JvmName("fpqfmviufeagnbpc")
    public suspend fun identityProviderOauthSettings(
        vararg
        values: Output<DomainDefaultUserSettingsCanvasAppSettingsIdentityProviderOauthSettingArgs>,
    ) {
        this.identityProviderOauthSettings = Output.all(values.asList())
    }

    /**
     * @param values The settings for connecting to an external data source with OAuth. See Identity Provider OAuth Settings below.
     */
    @JvmName("qjglydyjnitrxvhv")
    public suspend
    fun identityProviderOauthSettings(values: List<Output<DomainDefaultUserSettingsCanvasAppSettingsIdentityProviderOauthSettingArgs>>) {
        this.identityProviderOauthSettings = Output.all(values)
    }

    /**
     * @param value The settings for document querying. See Kendra Settings below.
     */
    @JvmName("fsrbdjgmqhfjxcho")
    public suspend
    fun kendraSettings(`value`: Output<DomainDefaultUserSettingsCanvasAppSettingsKendraSettingsArgs>) {
        this.kendraSettings = value
    }

    /**
     * @param value The model registry settings for the SageMaker Canvas application. See Model Register Settings below.
     */
    @JvmName("gjhcufxtqylhddie")
    public suspend
    fun modelRegisterSettings(`value`: Output<DomainDefaultUserSettingsCanvasAppSettingsModelRegisterSettingsArgs>) {
        this.modelRegisterSettings = value
    }

    /**
     * @param value Time series forecast settings for the Canvas app. See Time Series Forecasting Settings below.
     */
    @JvmName("pyerrxpabpfnfnqb")
    public suspend
    fun timeSeriesForecastingSettings(`value`: Output<DomainDefaultUserSettingsCanvasAppSettingsTimeSeriesForecastingSettingsArgs>) {
        this.timeSeriesForecastingSettings = value
    }

    /**
     * @param value The workspace settings for the SageMaker Canvas application. See Workspace Settings below.
     */
    @JvmName("gutdgqhvamdyelhf")
    public suspend
    fun workspaceSettings(`value`: Output<DomainDefaultUserSettingsCanvasAppSettingsWorkspaceSettingsArgs>) {
        this.workspaceSettings = value
    }

    /**
     * @param value The model deployment settings for the SageMaker Canvas application. See Direct Deploy Settings below.
     */
    @JvmName("essjbogtosoxodot")
    public suspend
    fun directDeploySettings(`value`: DomainDefaultUserSettingsCanvasAppSettingsDirectDeploySettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.directDeploySettings = mapped
    }

    /**
     * @param argument The model deployment settings for the SageMaker Canvas application. See Direct Deploy Settings below.
     */
    @JvmName("ommycroodsxjwncm")
    public suspend
    fun directDeploySettings(argument: suspend DomainDefaultUserSettingsCanvasAppSettingsDirectDeploySettingsArgsBuilder.() -> Unit) {
        val toBeMapped =
            DomainDefaultUserSettingsCanvasAppSettingsDirectDeploySettingsArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.directDeploySettings = mapped
    }

    /**
     * @param value The settings for connecting to an external data source with OAuth. See Identity Provider OAuth Settings below.
     */
    @JvmName("rueoetrxbgdnxmjv")
    public suspend
    fun identityProviderOauthSettings(`value`: List<DomainDefaultUserSettingsCanvasAppSettingsIdentityProviderOauthSettingArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.identityProviderOauthSettings = mapped
    }

    /**
     * @param argument The settings for connecting to an external data source with OAuth. See Identity Provider OAuth Settings below.
     */
    @JvmName("okmxgytnwxywjgts")
    public suspend
    fun identityProviderOauthSettings(argument: List<suspend DomainDefaultUserSettingsCanvasAppSettingsIdentityProviderOauthSettingArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            DomainDefaultUserSettingsCanvasAppSettingsIdentityProviderOauthSettingArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.identityProviderOauthSettings = mapped
    }

    /**
     * @param argument The settings for connecting to an external data source with OAuth. See Identity Provider OAuth Settings below.
     */
    @JvmName("jotudlfwmysqxhxs")
    public suspend fun identityProviderOauthSettings(
        vararg
        argument: suspend DomainDefaultUserSettingsCanvasAppSettingsIdentityProviderOauthSettingArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            DomainDefaultUserSettingsCanvasAppSettingsIdentityProviderOauthSettingArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.identityProviderOauthSettings = mapped
    }

    /**
     * @param argument The settings for connecting to an external data source with OAuth. See Identity Provider OAuth Settings below.
     */
    @JvmName("aphxoaeijltmyhvr")
    public suspend
    fun identityProviderOauthSettings(argument: suspend DomainDefaultUserSettingsCanvasAppSettingsIdentityProviderOauthSettingArgsBuilder.() -> Unit) {
        val toBeMapped =
            listOf(
                DomainDefaultUserSettingsCanvasAppSettingsIdentityProviderOauthSettingArgsBuilder().applySuspend
                    { argument() }.build(),
            )
        val mapped = of(toBeMapped)
        this.identityProviderOauthSettings = mapped
    }

    /**
     * @param values The settings for connecting to an external data source with OAuth. See Identity Provider OAuth Settings below.
     */
    @JvmName("akmklafvnxtglwmb")
    public suspend fun identityProviderOauthSettings(
        vararg
        values: DomainDefaultUserSettingsCanvasAppSettingsIdentityProviderOauthSettingArgs,
    ) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.identityProviderOauthSettings = mapped
    }

    /**
     * @param value The settings for document querying. See Kendra Settings below.
     */
    @JvmName("vpmkwskhmlvxrrbu")
    public suspend
    fun kendraSettings(`value`: DomainDefaultUserSettingsCanvasAppSettingsKendraSettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kendraSettings = mapped
    }

    /**
     * @param argument The settings for document querying. See Kendra Settings below.
     */
    @JvmName("sxtbvwggfyatehdu")
    public suspend
    fun kendraSettings(argument: suspend DomainDefaultUserSettingsCanvasAppSettingsKendraSettingsArgsBuilder.() -> Unit) {
        val toBeMapped =
            DomainDefaultUserSettingsCanvasAppSettingsKendraSettingsArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.kendraSettings = mapped
    }

    /**
     * @param value The model registry settings for the SageMaker Canvas application. See Model Register Settings below.
     */
    @JvmName("mlnxbjcramruwxpx")
    public suspend
    fun modelRegisterSettings(`value`: DomainDefaultUserSettingsCanvasAppSettingsModelRegisterSettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.modelRegisterSettings = mapped
    }

    /**
     * @param argument The model registry settings for the SageMaker Canvas application. See Model Register Settings below.
     */
    @JvmName("sbvpdrflhuigmcwu")
    public suspend
    fun modelRegisterSettings(argument: suspend DomainDefaultUserSettingsCanvasAppSettingsModelRegisterSettingsArgsBuilder.() -> Unit) {
        val toBeMapped =
            DomainDefaultUserSettingsCanvasAppSettingsModelRegisterSettingsArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.modelRegisterSettings = mapped
    }

    /**
     * @param value Time series forecast settings for the Canvas app. See Time Series Forecasting Settings below.
     */
    @JvmName("nqmleshvdtudnceu")
    public suspend
    fun timeSeriesForecastingSettings(`value`: DomainDefaultUserSettingsCanvasAppSettingsTimeSeriesForecastingSettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.timeSeriesForecastingSettings = mapped
    }

    /**
     * @param argument Time series forecast settings for the Canvas app. See Time Series Forecasting Settings below.
     */
    @JvmName("fcpewyqcgrxyggau")
    public suspend
    fun timeSeriesForecastingSettings(argument: suspend DomainDefaultUserSettingsCanvasAppSettingsTimeSeriesForecastingSettingsArgsBuilder.() -> Unit) {
        val toBeMapped =
            DomainDefaultUserSettingsCanvasAppSettingsTimeSeriesForecastingSettingsArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.timeSeriesForecastingSettings = mapped
    }

    /**
     * @param value The workspace settings for the SageMaker Canvas application. See Workspace Settings below.
     */
    @JvmName("umajikevblusfycn")
    public suspend
    fun workspaceSettings(`value`: DomainDefaultUserSettingsCanvasAppSettingsWorkspaceSettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.workspaceSettings = mapped
    }

    /**
     * @param argument The workspace settings for the SageMaker Canvas application. See Workspace Settings below.
     */
    @JvmName("tvgmstqnsydabwgc")
    public suspend
    fun workspaceSettings(argument: suspend DomainDefaultUserSettingsCanvasAppSettingsWorkspaceSettingsArgsBuilder.() -> Unit) {
        val toBeMapped =
            DomainDefaultUserSettingsCanvasAppSettingsWorkspaceSettingsArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.workspaceSettings = mapped
    }

    internal fun build(): DomainDefaultUserSettingsCanvasAppSettingsArgs =
        DomainDefaultUserSettingsCanvasAppSettingsArgs(
            directDeploySettings = directDeploySettings,
            identityProviderOauthSettings = identityProviderOauthSettings,
            kendraSettings = kendraSettings,
            modelRegisterSettings = modelRegisterSettings,
            timeSeriesForecastingSettings = timeSeriesForecastingSettings,
            workspaceSettings = workspaceSettings,
        )
}
