@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sagemaker.kotlin.inputs

import com.pulumi.aws.sagemaker.inputs.DomainDefaultUserSettingsCanvasAppSettingsDirectDeploySettingsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property status Describes whether model deployment permissions are enabled or disabled in the Canvas application. Valid values are `ENABLED` and `DISABLED`.
 */
public data class DomainDefaultUserSettingsCanvasAppSettingsDirectDeploySettingsArgs(
    public val status: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.sagemaker.inputs.DomainDefaultUserSettingsCanvasAppSettingsDirectDeploySettingsArgs> {
    override fun toJava():
        com.pulumi.aws.sagemaker.inputs.DomainDefaultUserSettingsCanvasAppSettingsDirectDeploySettingsArgs =
        com.pulumi.aws.sagemaker.inputs.DomainDefaultUserSettingsCanvasAppSettingsDirectDeploySettingsArgs.builder()
            .status(status?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DomainDefaultUserSettingsCanvasAppSettingsDirectDeploySettingsArgs].
 */
@PulumiTagMarker
public class DomainDefaultUserSettingsCanvasAppSettingsDirectDeploySettingsArgsBuilder internal
constructor() {
    private var status: Output<String>? = null

    /**
     * @param value Describes whether model deployment permissions are enabled or disabled in the Canvas application. Valid values are `ENABLED` and `DISABLED`.
     */
    @JvmName("umsvnfglcjstvicx")
    public suspend fun status(`value`: Output<String>) {
        this.status = value
    }

    /**
     * @param value Describes whether model deployment permissions are enabled or disabled in the Canvas application. Valid values are `ENABLED` and `DISABLED`.
     */
    @JvmName("gxdjgnepnoqhkcqs")
    public suspend fun status(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.status = mapped
    }

    internal fun build(): DomainDefaultUserSettingsCanvasAppSettingsDirectDeploySettingsArgs =
        DomainDefaultUserSettingsCanvasAppSettingsDirectDeploySettingsArgs(
            status = status,
        )
}
