@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sagemaker.kotlin.inputs

import com.pulumi.aws.sagemaker.inputs.DomainDefaultUserSettingsCanvasAppSettingsModelRegisterSettingsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property crossAccountModelRegisterRoleArn The Amazon Resource Name (ARN) of the SageMaker model registry account. Required only to register model versions created by a different SageMaker Canvas AWS account than the AWS account in which SageMaker model registry is set up.
 * @property status Describes whether the integration to the model registry is enabled or disabled in the Canvas application. Valid values are `ENABLED` and `DISABLED`.
 */
public data class DomainDefaultUserSettingsCanvasAppSettingsModelRegisterSettingsArgs(
    public val crossAccountModelRegisterRoleArn: Output<String>? = null,
    public val status: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.sagemaker.inputs.DomainDefaultUserSettingsCanvasAppSettingsModelRegisterSettingsArgs> {
    override fun toJava():
        com.pulumi.aws.sagemaker.inputs.DomainDefaultUserSettingsCanvasAppSettingsModelRegisterSettingsArgs =
        com.pulumi.aws.sagemaker.inputs.DomainDefaultUserSettingsCanvasAppSettingsModelRegisterSettingsArgs.builder()
            .crossAccountModelRegisterRoleArn(crossAccountModelRegisterRoleArn?.applyValue({ args0 -> args0 }))
            .status(status?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DomainDefaultUserSettingsCanvasAppSettingsModelRegisterSettingsArgs].
 */
@PulumiTagMarker
public class DomainDefaultUserSettingsCanvasAppSettingsModelRegisterSettingsArgsBuilder internal
constructor() {
    private var crossAccountModelRegisterRoleArn: Output<String>? = null

    private var status: Output<String>? = null

    /**
     * @param value The Amazon Resource Name (ARN) of the SageMaker model registry account. Required only to register model versions created by a different SageMaker Canvas AWS account than the AWS account in which SageMaker model registry is set up.
     */
    @JvmName("vofqqcwmgwuephdu")
    public suspend fun crossAccountModelRegisterRoleArn(`value`: Output<String>) {
        this.crossAccountModelRegisterRoleArn = value
    }

    /**
     * @param value Describes whether the integration to the model registry is enabled or disabled in the Canvas application. Valid values are `ENABLED` and `DISABLED`.
     */
    @JvmName("canvfbresnuojkmf")
    public suspend fun status(`value`: Output<String>) {
        this.status = value
    }

    /**
     * @param value The Amazon Resource Name (ARN) of the SageMaker model registry account. Required only to register model versions created by a different SageMaker Canvas AWS account than the AWS account in which SageMaker model registry is set up.
     */
    @JvmName("wxdhkvfheryfsgqr")
    public suspend fun crossAccountModelRegisterRoleArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.crossAccountModelRegisterRoleArn = mapped
    }

    /**
     * @param value Describes whether the integration to the model registry is enabled or disabled in the Canvas application. Valid values are `ENABLED` and `DISABLED`.
     */
    @JvmName("sbjosmblsnrhuume")
    public suspend fun status(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.status = mapped
    }

    internal fun build(): DomainDefaultUserSettingsCanvasAppSettingsModelRegisterSettingsArgs =
        DomainDefaultUserSettingsCanvasAppSettingsModelRegisterSettingsArgs(
            crossAccountModelRegisterRoleArn = crossAccountModelRegisterRoleArn,
            status = status,
        )
}
