@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sagemaker.kotlin.inputs

import com.pulumi.aws.sagemaker.inputs.DomainDefaultUserSettingsRSessionAppSettingsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property customImages A list of custom SageMaker images that are configured to run as a KernelGateway app. see Custom Image below.
 * @property defaultResourceSpec The default instance type and the Amazon Resource Name (ARN) of the SageMaker image created on the instance. see Default Resource Spec below.
 */
public data class DomainDefaultUserSettingsRSessionAppSettingsArgs(
    public val customImages:
    Output<List<DomainDefaultUserSettingsRSessionAppSettingsCustomImageArgs>>? = null,
    public val defaultResourceSpec:
    Output<DomainDefaultUserSettingsRSessionAppSettingsDefaultResourceSpecArgs>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.sagemaker.inputs.DomainDefaultUserSettingsRSessionAppSettingsArgs> {
    override fun toJava():
        com.pulumi.aws.sagemaker.inputs.DomainDefaultUserSettingsRSessionAppSettingsArgs =
        com.pulumi.aws.sagemaker.inputs.DomainDefaultUserSettingsRSessionAppSettingsArgs.builder()
            .customImages(
                customImages?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .defaultResourceSpec(
                defaultResourceSpec?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [DomainDefaultUserSettingsRSessionAppSettingsArgs].
 */
@PulumiTagMarker
public class DomainDefaultUserSettingsRSessionAppSettingsArgsBuilder internal constructor() {
    private var customImages:
        Output<List<DomainDefaultUserSettingsRSessionAppSettingsCustomImageArgs>>? = null

    private var defaultResourceSpec:
        Output<DomainDefaultUserSettingsRSessionAppSettingsDefaultResourceSpecArgs>? = null

    /**
     * @param value A list of custom SageMaker images that are configured to run as a KernelGateway app. see Custom Image below.
     */
    @JvmName("yuljxjmtbpdkqymr")
    public suspend
    fun customImages(`value`: Output<List<DomainDefaultUserSettingsRSessionAppSettingsCustomImageArgs>>) {
        this.customImages = value
    }

    @JvmName("kgiocfxllviuylct")
    public suspend fun customImages(
        vararg
        values: Output<DomainDefaultUserSettingsRSessionAppSettingsCustomImageArgs>,
    ) {
        this.customImages = Output.all(values.asList())
    }

    /**
     * @param values A list of custom SageMaker images that are configured to run as a KernelGateway app. see Custom Image below.
     */
    @JvmName("uqhmytodskddqxlc")
    public suspend
    fun customImages(values: List<Output<DomainDefaultUserSettingsRSessionAppSettingsCustomImageArgs>>) {
        this.customImages = Output.all(values)
    }

    /**
     * @param value The default instance type and the Amazon Resource Name (ARN) of the SageMaker image created on the instance. see Default Resource Spec below.
     */
    @JvmName("gebersvrenplewom")
    public suspend
    fun defaultResourceSpec(`value`: Output<DomainDefaultUserSettingsRSessionAppSettingsDefaultResourceSpecArgs>) {
        this.defaultResourceSpec = value
    }

    /**
     * @param value A list of custom SageMaker images that are configured to run as a KernelGateway app. see Custom Image below.
     */
    @JvmName("eqlhffjuugayfetr")
    public suspend
    fun customImages(`value`: List<DomainDefaultUserSettingsRSessionAppSettingsCustomImageArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.customImages = mapped
    }

    /**
     * @param argument A list of custom SageMaker images that are configured to run as a KernelGateway app. see Custom Image below.
     */
    @JvmName("kclsvljipobalxjy")
    public suspend
    fun customImages(argument: List<suspend DomainDefaultUserSettingsRSessionAppSettingsCustomImageArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            DomainDefaultUserSettingsRSessionAppSettingsCustomImageArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.customImages = mapped
    }

    /**
     * @param argument A list of custom SageMaker images that are configured to run as a KernelGateway app. see Custom Image below.
     */
    @JvmName("vhcyecjtkmwsshho")
    public suspend fun customImages(
        vararg
        argument: suspend DomainDefaultUserSettingsRSessionAppSettingsCustomImageArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            DomainDefaultUserSettingsRSessionAppSettingsCustomImageArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.customImages = mapped
    }

    /**
     * @param argument A list of custom SageMaker images that are configured to run as a KernelGateway app. see Custom Image below.
     */
    @JvmName("ybsrbeikhmanibiv")
    public suspend
    fun customImages(argument: suspend DomainDefaultUserSettingsRSessionAppSettingsCustomImageArgsBuilder.() -> Unit) {
        val toBeMapped =
            listOf(
                DomainDefaultUserSettingsRSessionAppSettingsCustomImageArgsBuilder().applySuspend {
                    argument()
                }.build(),
            )
        val mapped = of(toBeMapped)
        this.customImages = mapped
    }

    /**
     * @param values A list of custom SageMaker images that are configured to run as a KernelGateway app. see Custom Image below.
     */
    @JvmName("vbuijanwvkxnmrxi")
    public suspend fun customImages(
        vararg
        values: DomainDefaultUserSettingsRSessionAppSettingsCustomImageArgs,
    ) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.customImages = mapped
    }

    /**
     * @param value The default instance type and the Amazon Resource Name (ARN) of the SageMaker image created on the instance. see Default Resource Spec below.
     */
    @JvmName("sbeignmvimnuqvyn")
    public suspend
    fun defaultResourceSpec(`value`: DomainDefaultUserSettingsRSessionAppSettingsDefaultResourceSpecArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.defaultResourceSpec = mapped
    }

    /**
     * @param argument The default instance type and the Amazon Resource Name (ARN) of the SageMaker image created on the instance. see Default Resource Spec below.
     */
    @JvmName("vsosxqmxgiblamou")
    public suspend
    fun defaultResourceSpec(argument: suspend DomainDefaultUserSettingsRSessionAppSettingsDefaultResourceSpecArgsBuilder.() -> Unit) {
        val toBeMapped =
            DomainDefaultUserSettingsRSessionAppSettingsDefaultResourceSpecArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.defaultResourceSpec = mapped
    }

    internal fun build(): DomainDefaultUserSettingsRSessionAppSettingsArgs =
        DomainDefaultUserSettingsRSessionAppSettingsArgs(
            customImages = customImages,
            defaultResourceSpec = defaultResourceSpec,
        )
}
