@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sagemaker.kotlin.inputs

import com.pulumi.aws.sagemaker.inputs.DomainDefaultUserSettingsSharingSettingsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property notebookOutputOption Whether to include the notebook cell output when sharing the notebook. The default is `Disabled`. Valid values are `Allowed` and `Disabled`.
 * @property s3KmsKeyId When `notebook_output_option` is Allowed, the AWS Key Management Service (KMS) encryption key ID used to encrypt the notebook cell output in the Amazon S3 bucket.
 * @property s3OutputPath When `notebook_output_option` is Allowed, the Amazon S3 bucket used to save the notebook cell output.
 */
public data class DomainDefaultUserSettingsSharingSettingsArgs(
    public val notebookOutputOption: Output<String>? = null,
    public val s3KmsKeyId: Output<String>? = null,
    public val s3OutputPath: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.sagemaker.inputs.DomainDefaultUserSettingsSharingSettingsArgs> {
    override fun toJava():
        com.pulumi.aws.sagemaker.inputs.DomainDefaultUserSettingsSharingSettingsArgs =
        com.pulumi.aws.sagemaker.inputs.DomainDefaultUserSettingsSharingSettingsArgs.builder()
            .notebookOutputOption(notebookOutputOption?.applyValue({ args0 -> args0 }))
            .s3KmsKeyId(s3KmsKeyId?.applyValue({ args0 -> args0 }))
            .s3OutputPath(s3OutputPath?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DomainDefaultUserSettingsSharingSettingsArgs].
 */
@PulumiTagMarker
public class DomainDefaultUserSettingsSharingSettingsArgsBuilder internal constructor() {
    private var notebookOutputOption: Output<String>? = null

    private var s3KmsKeyId: Output<String>? = null

    private var s3OutputPath: Output<String>? = null

    /**
     * @param value Whether to include the notebook cell output when sharing the notebook. The default is `Disabled`. Valid values are `Allowed` and `Disabled`.
     */
    @JvmName("yxalysjuvfmhqpga")
    public suspend fun notebookOutputOption(`value`: Output<String>) {
        this.notebookOutputOption = value
    }

    /**
     * @param value When `notebook_output_option` is Allowed, the AWS Key Management Service (KMS) encryption key ID used to encrypt the notebook cell output in the Amazon S3 bucket.
     */
    @JvmName("jufuwdqustmlyayn")
    public suspend fun s3KmsKeyId(`value`: Output<String>) {
        this.s3KmsKeyId = value
    }

    /**
     * @param value When `notebook_output_option` is Allowed, the Amazon S3 bucket used to save the notebook cell output.
     */
    @JvmName("sqytpyxdbopxllsa")
    public suspend fun s3OutputPath(`value`: Output<String>) {
        this.s3OutputPath = value
    }

    /**
     * @param value Whether to include the notebook cell output when sharing the notebook. The default is `Disabled`. Valid values are `Allowed` and `Disabled`.
     */
    @JvmName("gqbrnlwhxprdhnlj")
    public suspend fun notebookOutputOption(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.notebookOutputOption = mapped
    }

    /**
     * @param value When `notebook_output_option` is Allowed, the AWS Key Management Service (KMS) encryption key ID used to encrypt the notebook cell output in the Amazon S3 bucket.
     */
    @JvmName("iokjhmcccbwfhoij")
    public suspend fun s3KmsKeyId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.s3KmsKeyId = mapped
    }

    /**
     * @param value When `notebook_output_option` is Allowed, the Amazon S3 bucket used to save the notebook cell output.
     */
    @JvmName("htbuvlngstejhdoh")
    public suspend fun s3OutputPath(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.s3OutputPath = mapped
    }

    internal fun build(): DomainDefaultUserSettingsSharingSettingsArgs =
        DomainDefaultUserSettingsSharingSettingsArgs(
            notebookOutputOption = notebookOutputOption,
            s3KmsKeyId = s3KmsKeyId,
            s3OutputPath = s3OutputPath,
        )
}
