@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sagemaker.kotlin.inputs

import com.pulumi.aws.sagemaker.inputs.DomainDomainSettingsRStudioServerProDomainSettingsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property defaultResourceSpec The default instance type and the Amazon Resource Name (ARN) of the SageMaker image created on the instance. see Default Resource Spec below.
 * @property domainExecutionRoleArn The ARN of the execution role for the RStudioServerPro Domain-level app.
 * @property rStudioConnectUrl A URL pointing to an RStudio Connect server.
 * @property rStudioPackageManagerUrl A URL pointing to an RStudio Package Manager server.
 */
public data class DomainDomainSettingsRStudioServerProDomainSettingsArgs(
    public val defaultResourceSpec:
    Output<DomainDomainSettingsRStudioServerProDomainSettingsDefaultResourceSpecArgs>? = null,
    public val domainExecutionRoleArn: Output<String>,
    public val rStudioConnectUrl: Output<String>? = null,
    public val rStudioPackageManagerUrl: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.sagemaker.inputs.DomainDomainSettingsRStudioServerProDomainSettingsArgs> {
    override fun toJava():
        com.pulumi.aws.sagemaker.inputs.DomainDomainSettingsRStudioServerProDomainSettingsArgs =
        com.pulumi.aws.sagemaker.inputs.DomainDomainSettingsRStudioServerProDomainSettingsArgs.builder()
            .defaultResourceSpec(
                defaultResourceSpec?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .domainExecutionRoleArn(domainExecutionRoleArn.applyValue({ args0 -> args0 }))
            .rStudioConnectUrl(rStudioConnectUrl?.applyValue({ args0 -> args0 }))
            .rStudioPackageManagerUrl(rStudioPackageManagerUrl?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DomainDomainSettingsRStudioServerProDomainSettingsArgs].
 */
@PulumiTagMarker
public class DomainDomainSettingsRStudioServerProDomainSettingsArgsBuilder internal constructor() {
    private var defaultResourceSpec:
        Output<DomainDomainSettingsRStudioServerProDomainSettingsDefaultResourceSpecArgs>? = null

    private var domainExecutionRoleArn: Output<String>? = null

    private var rStudioConnectUrl: Output<String>? = null

    private var rStudioPackageManagerUrl: Output<String>? = null

    /**
     * @param value The default instance type and the Amazon Resource Name (ARN) of the SageMaker image created on the instance. see Default Resource Spec below.
     */
    @JvmName("lkxrkjfbxkpoxslx")
    public suspend
    fun defaultResourceSpec(`value`: Output<DomainDomainSettingsRStudioServerProDomainSettingsDefaultResourceSpecArgs>) {
        this.defaultResourceSpec = value
    }

    /**
     * @param value The ARN of the execution role for the RStudioServerPro Domain-level app.
     */
    @JvmName("ynrpwoldlhydlara")
    public suspend fun domainExecutionRoleArn(`value`: Output<String>) {
        this.domainExecutionRoleArn = value
    }

    /**
     * @param value A URL pointing to an RStudio Connect server.
     */
    @JvmName("tovowhveiebyixlo")
    public suspend fun rStudioConnectUrl(`value`: Output<String>) {
        this.rStudioConnectUrl = value
    }

    /**
     * @param value A URL pointing to an RStudio Package Manager server.
     */
    @JvmName("nxjrjoeemrncfeye")
    public suspend fun rStudioPackageManagerUrl(`value`: Output<String>) {
        this.rStudioPackageManagerUrl = value
    }

    /**
     * @param value The default instance type and the Amazon Resource Name (ARN) of the SageMaker image created on the instance. see Default Resource Spec below.
     */
    @JvmName("csoffhheonojstnn")
    public suspend
    fun defaultResourceSpec(`value`: DomainDomainSettingsRStudioServerProDomainSettingsDefaultResourceSpecArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.defaultResourceSpec = mapped
    }

    /**
     * @param argument The default instance type and the Amazon Resource Name (ARN) of the SageMaker image created on the instance. see Default Resource Spec below.
     */
    @JvmName("fupkrpakcinxumhr")
    public suspend
    fun defaultResourceSpec(argument: suspend DomainDomainSettingsRStudioServerProDomainSettingsDefaultResourceSpecArgsBuilder.() -> Unit) {
        val toBeMapped =
            DomainDomainSettingsRStudioServerProDomainSettingsDefaultResourceSpecArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.defaultResourceSpec = mapped
    }

    /**
     * @param value The ARN of the execution role for the RStudioServerPro Domain-level app.
     */
    @JvmName("cxsmgmyyjyjsuiyj")
    public suspend fun domainExecutionRoleArn(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.domainExecutionRoleArn = mapped
    }

    /**
     * @param value A URL pointing to an RStudio Connect server.
     */
    @JvmName("xlbprfyiqqvmtsgv")
    public suspend fun rStudioConnectUrl(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.rStudioConnectUrl = mapped
    }

    /**
     * @param value A URL pointing to an RStudio Package Manager server.
     */
    @JvmName("oahwnukqbumrejgu")
    public suspend fun rStudioPackageManagerUrl(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.rStudioPackageManagerUrl = mapped
    }

    internal fun build(): DomainDomainSettingsRStudioServerProDomainSettingsArgs =
        DomainDomainSettingsRStudioServerProDomainSettingsArgs(
            defaultResourceSpec = defaultResourceSpec,
            domainExecutionRoleArn = domainExecutionRoleArn ?: throw
                PulumiNullFieldException("domainExecutionRoleArn"),
            rStudioConnectUrl = rStudioConnectUrl,
            rStudioPackageManagerUrl = rStudioPackageManagerUrl,
        )
}
