@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sagemaker.kotlin.inputs

import com.pulumi.aws.sagemaker.inputs.DomainDomainSettingsRStudioServerProDomainSettingsDefaultResourceSpecArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property instanceType The instance type that the image version runs on.. For valid values see [SageMaker Instance Types](https://docs.aws.amazon.com/sagemaker/latest/dg/notebooks-available-instance-types.html).
 * @property lifecycleConfigArn The Amazon Resource Name (ARN) of the Lifecycle Configuration attached to the Resource.
 * @property sagemakerImageArn The ARN of the SageMaker image that the image version belongs to.
 * @property sagemakerImageVersionArn The ARN of the image version created on the instance.
 */
public data class DomainDomainSettingsRStudioServerProDomainSettingsDefaultResourceSpecArgs(
    public val instanceType: Output<String>? = null,
    public val lifecycleConfigArn: Output<String>? = null,
    public val sagemakerImageArn: Output<String>? = null,
    public val sagemakerImageVersionArn: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.sagemaker.inputs.DomainDomainSettingsRStudioServerProDomainSettingsDefaultResourceSpecArgs> {
    override fun toJava():
        com.pulumi.aws.sagemaker.inputs.DomainDomainSettingsRStudioServerProDomainSettingsDefaultResourceSpecArgs =
        com.pulumi.aws.sagemaker.inputs.DomainDomainSettingsRStudioServerProDomainSettingsDefaultResourceSpecArgs.builder()
            .instanceType(instanceType?.applyValue({ args0 -> args0 }))
            .lifecycleConfigArn(lifecycleConfigArn?.applyValue({ args0 -> args0 }))
            .sagemakerImageArn(sagemakerImageArn?.applyValue({ args0 -> args0 }))
            .sagemakerImageVersionArn(sagemakerImageVersionArn?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DomainDomainSettingsRStudioServerProDomainSettingsDefaultResourceSpecArgs].
 */
@PulumiTagMarker
public class DomainDomainSettingsRStudioServerProDomainSettingsDefaultResourceSpecArgsBuilder
internal constructor() {
    private var instanceType: Output<String>? = null

    private var lifecycleConfigArn: Output<String>? = null

    private var sagemakerImageArn: Output<String>? = null

    private var sagemakerImageVersionArn: Output<String>? = null

    /**
     * @param value The instance type that the image version runs on.. For valid values see [SageMaker Instance Types](https://docs.aws.amazon.com/sagemaker/latest/dg/notebooks-available-instance-types.html).
     */
    @JvmName("scvltquvdckegbls")
    public suspend fun instanceType(`value`: Output<String>) {
        this.instanceType = value
    }

    /**
     * @param value The Amazon Resource Name (ARN) of the Lifecycle Configuration attached to the Resource.
     */
    @JvmName("rjhyuqqxgdcekxuv")
    public suspend fun lifecycleConfigArn(`value`: Output<String>) {
        this.lifecycleConfigArn = value
    }

    /**
     * @param value The ARN of the SageMaker image that the image version belongs to.
     */
    @JvmName("yrwjadyktcgnclgf")
    public suspend fun sagemakerImageArn(`value`: Output<String>) {
        this.sagemakerImageArn = value
    }

    /**
     * @param value The ARN of the image version created on the instance.
     */
    @JvmName("mvhbiyjnvajdktnf")
    public suspend fun sagemakerImageVersionArn(`value`: Output<String>) {
        this.sagemakerImageVersionArn = value
    }

    /**
     * @param value The instance type that the image version runs on.. For valid values see [SageMaker Instance Types](https://docs.aws.amazon.com/sagemaker/latest/dg/notebooks-available-instance-types.html).
     */
    @JvmName("srtaneoaqkcyyjvl")
    public suspend fun instanceType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.instanceType = mapped
    }

    /**
     * @param value The Amazon Resource Name (ARN) of the Lifecycle Configuration attached to the Resource.
     */
    @JvmName("srrqemksbwmmrdac")
    public suspend fun lifecycleConfigArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.lifecycleConfigArn = mapped
    }

    /**
     * @param value The ARN of the SageMaker image that the image version belongs to.
     */
    @JvmName("imccsikiqndkaytf")
    public suspend fun sagemakerImageArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sagemakerImageArn = mapped
    }

    /**
     * @param value The ARN of the image version created on the instance.
     */
    @JvmName("vufktlcjpyhmvboc")
    public suspend fun sagemakerImageVersionArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sagemakerImageVersionArn = mapped
    }

    internal fun build(): DomainDomainSettingsRStudioServerProDomainSettingsDefaultResourceSpecArgs =
        DomainDomainSettingsRStudioServerProDomainSettingsDefaultResourceSpecArgs(
            instanceType = instanceType,
            lifecycleConfigArn = lifecycleConfigArn,
            sagemakerImageArn = sagemakerImageArn,
            sagemakerImageVersionArn = sagemakerImageVersionArn,
        )
}
