@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sagemaker.kotlin.inputs

import com.pulumi.aws.sagemaker.inputs.DomainRetentionPolicyArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property homeEfsFileSystem The retention policy for data stored on an Amazon Elastic File System (EFS) volume. Valid values are `Retain` or `Delete`.  Default value is `Retain`.
 */
public data class DomainRetentionPolicyArgs(
    public val homeEfsFileSystem: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.sagemaker.inputs.DomainRetentionPolicyArgs> {
    override fun toJava(): com.pulumi.aws.sagemaker.inputs.DomainRetentionPolicyArgs =
        com.pulumi.aws.sagemaker.inputs.DomainRetentionPolicyArgs.builder()
            .homeEfsFileSystem(homeEfsFileSystem?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DomainRetentionPolicyArgs].
 */
@PulumiTagMarker
public class DomainRetentionPolicyArgsBuilder internal constructor() {
    private var homeEfsFileSystem: Output<String>? = null

    /**
     * @param value The retention policy for data stored on an Amazon Elastic File System (EFS) volume. Valid values are `Retain` or `Delete`.  Default value is `Retain`.
     */
    @JvmName("vlcsssippjnuexrt")
    public suspend fun homeEfsFileSystem(`value`: Output<String>) {
        this.homeEfsFileSystem = value
    }

    /**
     * @param value The retention policy for data stored on an Amazon Elastic File System (EFS) volume. Valid values are `Retain` or `Delete`.  Default value is `Retain`.
     */
    @JvmName("ljccdijxyewdlipq")
    public suspend fun homeEfsFileSystem(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.homeEfsFileSystem = mapped
    }

    internal fun build(): DomainRetentionPolicyArgs = DomainRetentionPolicyArgs(
        homeEfsFileSystem = homeEfsFileSystem,
    )
}
