@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sagemaker.kotlin.inputs

import com.pulumi.aws.sagemaker.inputs.EndpointConfigurationAsyncInferenceConfigArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property clientConfig Configures the behavior of the client used by Amazon SageMaker to interact with the model container during asynchronous inference.
 * @property outputConfig Specifies the configuration for asynchronous inference invocation outputs.
 */
public data class EndpointConfigurationAsyncInferenceConfigArgs(
    public val clientConfig: Output<EndpointConfigurationAsyncInferenceConfigClientConfigArgs>? =
        null,
    public val outputConfig: Output<EndpointConfigurationAsyncInferenceConfigOutputConfigArgs>,
) : ConvertibleToJava<com.pulumi.aws.sagemaker.inputs.EndpointConfigurationAsyncInferenceConfigArgs> {
    override fun toJava():
        com.pulumi.aws.sagemaker.inputs.EndpointConfigurationAsyncInferenceConfigArgs =
        com.pulumi.aws.sagemaker.inputs.EndpointConfigurationAsyncInferenceConfigArgs.builder()
            .clientConfig(clientConfig?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .outputConfig(outputConfig.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [EndpointConfigurationAsyncInferenceConfigArgs].
 */
@PulumiTagMarker
public class EndpointConfigurationAsyncInferenceConfigArgsBuilder internal constructor() {
    private var clientConfig: Output<EndpointConfigurationAsyncInferenceConfigClientConfigArgs>? =
        null

    private var outputConfig: Output<EndpointConfigurationAsyncInferenceConfigOutputConfigArgs>? =
        null

    /**
     * @param value Configures the behavior of the client used by Amazon SageMaker to interact with the model container during asynchronous inference.
     */
    @JvmName("pvreoveyaeqktluo")
    public suspend
    fun clientConfig(`value`: Output<EndpointConfigurationAsyncInferenceConfigClientConfigArgs>) {
        this.clientConfig = value
    }

    /**
     * @param value Specifies the configuration for asynchronous inference invocation outputs.
     */
    @JvmName("bjxiqcgyuvnlnmov")
    public suspend
    fun outputConfig(`value`: Output<EndpointConfigurationAsyncInferenceConfigOutputConfigArgs>) {
        this.outputConfig = value
    }

    /**
     * @param value Configures the behavior of the client used by Amazon SageMaker to interact with the model container during asynchronous inference.
     */
    @JvmName("rajvstyaavflhxci")
    public suspend
    fun clientConfig(`value`: EndpointConfigurationAsyncInferenceConfigClientConfigArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clientConfig = mapped
    }

    /**
     * @param argument Configures the behavior of the client used by Amazon SageMaker to interact with the model container during asynchronous inference.
     */
    @JvmName("yxstfpptvxognegg")
    public suspend
    fun clientConfig(argument: suspend EndpointConfigurationAsyncInferenceConfigClientConfigArgsBuilder.() -> Unit) {
        val toBeMapped =
            EndpointConfigurationAsyncInferenceConfigClientConfigArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.clientConfig = mapped
    }

    /**
     * @param value Specifies the configuration for asynchronous inference invocation outputs.
     */
    @JvmName("wueelaophfndalok")
    public suspend
    fun outputConfig(`value`: EndpointConfigurationAsyncInferenceConfigOutputConfigArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.outputConfig = mapped
    }

    /**
     * @param argument Specifies the configuration for asynchronous inference invocation outputs.
     */
    @JvmName("ylahdotwvronmisj")
    public suspend
    fun outputConfig(argument: suspend EndpointConfigurationAsyncInferenceConfigOutputConfigArgsBuilder.() -> Unit) {
        val toBeMapped =
            EndpointConfigurationAsyncInferenceConfigOutputConfigArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.outputConfig = mapped
    }

    internal fun build(): EndpointConfigurationAsyncInferenceConfigArgs =
        EndpointConfigurationAsyncInferenceConfigArgs(
            clientConfig = clientConfig,
            outputConfig = outputConfig ?: throw PulumiNullFieldException("outputConfig"),
        )
}
