@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sagemaker.kotlin.inputs

import com.pulumi.aws.sagemaker.inputs.EndpointConfigurationAsyncInferenceConfigOutputConfigNotificationConfigArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property errorTopic Amazon SNS topic to post a notification to when inference fails. If no topic is provided, no notification is sent on failure.
 * @property includeInferenceResponseIns The Amazon SNS topics where you want the inference response to be included. Valid values are `SUCCESS_NOTIFICATION_TOPIC` and `ERROR_NOTIFICATION_TOPIC`.
 * @property successTopic Amazon SNS topic to post a notification to when inference completes successfully. If no topic is provided, no notification is sent on success.
 */
public data class EndpointConfigurationAsyncInferenceConfigOutputConfigNotificationConfigArgs(
    public val errorTopic: Output<String>? = null,
    public val includeInferenceResponseIns: Output<List<String>>? = null,
    public val successTopic: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.sagemaker.inputs.EndpointConfigurationAsyncInferenceConfigOutputConfigNotificationConfigArgs> {
    override fun toJava():
        com.pulumi.aws.sagemaker.inputs.EndpointConfigurationAsyncInferenceConfigOutputConfigNotificationConfigArgs =
        com.pulumi.aws.sagemaker.inputs.EndpointConfigurationAsyncInferenceConfigOutputConfigNotificationConfigArgs.builder()
            .errorTopic(errorTopic?.applyValue({ args0 -> args0 }))
            .includeInferenceResponseIns(
                includeInferenceResponseIns?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0
                    })
                }),
            )
            .successTopic(successTopic?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [EndpointConfigurationAsyncInferenceConfigOutputConfigNotificationConfigArgs].
 */
@PulumiTagMarker
public class EndpointConfigurationAsyncInferenceConfigOutputConfigNotificationConfigArgsBuilder
internal constructor() {
    private var errorTopic: Output<String>? = null

    private var includeInferenceResponseIns: Output<List<String>>? = null

    private var successTopic: Output<String>? = null

    /**
     * @param value Amazon SNS topic to post a notification to when inference fails. If no topic is provided, no notification is sent on failure.
     */
    @JvmName("yewkcfibwhcvrjwd")
    public suspend fun errorTopic(`value`: Output<String>) {
        this.errorTopic = value
    }

    /**
     * @param value The Amazon SNS topics where you want the inference response to be included. Valid values are `SUCCESS_NOTIFICATION_TOPIC` and `ERROR_NOTIFICATION_TOPIC`.
     */
    @JvmName("vhnvsvfgsqgjkmuw")
    public suspend fun includeInferenceResponseIns(`value`: Output<List<String>>) {
        this.includeInferenceResponseIns = value
    }

    @JvmName("nvaaxovcuwpxgitb")
    public suspend fun includeInferenceResponseIns(vararg values: Output<String>) {
        this.includeInferenceResponseIns = Output.all(values.asList())
    }

    /**
     * @param values The Amazon SNS topics where you want the inference response to be included. Valid values are `SUCCESS_NOTIFICATION_TOPIC` and `ERROR_NOTIFICATION_TOPIC`.
     */
    @JvmName("uioqkxprlsxewbgh")
    public suspend fun includeInferenceResponseIns(values: List<Output<String>>) {
        this.includeInferenceResponseIns = Output.all(values)
    }

    /**
     * @param value Amazon SNS topic to post a notification to when inference completes successfully. If no topic is provided, no notification is sent on success.
     */
    @JvmName("ewrgtouuockntosa")
    public suspend fun successTopic(`value`: Output<String>) {
        this.successTopic = value
    }

    /**
     * @param value Amazon SNS topic to post a notification to when inference fails. If no topic is provided, no notification is sent on failure.
     */
    @JvmName("fhmqxfbadxleyifg")
    public suspend fun errorTopic(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.errorTopic = mapped
    }

    /**
     * @param value The Amazon SNS topics where you want the inference response to be included. Valid values are `SUCCESS_NOTIFICATION_TOPIC` and `ERROR_NOTIFICATION_TOPIC`.
     */
    @JvmName("pescerfhkvcprwfm")
    public suspend fun includeInferenceResponseIns(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.includeInferenceResponseIns = mapped
    }

    /**
     * @param values The Amazon SNS topics where you want the inference response to be included. Valid values are `SUCCESS_NOTIFICATION_TOPIC` and `ERROR_NOTIFICATION_TOPIC`.
     */
    @JvmName("stmfnburbrhqtnpr")
    public suspend fun includeInferenceResponseIns(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.includeInferenceResponseIns = mapped
    }

    /**
     * @param value Amazon SNS topic to post a notification to when inference completes successfully. If no topic is provided, no notification is sent on success.
     */
    @JvmName("fumcsrrsoqitghec")
    public suspend fun successTopic(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.successTopic = mapped
    }

    internal fun build(): EndpointConfigurationAsyncInferenceConfigOutputConfigNotificationConfigArgs =
        EndpointConfigurationAsyncInferenceConfigOutputConfigNotificationConfigArgs(
            errorTopic = errorTopic,
            includeInferenceResponseIns = includeInferenceResponseIns,
            successTopic = successTopic,
        )
}
