@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sagemaker.kotlin.inputs

import com.pulumi.aws.sagemaker.inputs.EndpointConfigurationDataCaptureConfigArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property captureContentTypeHeader The content type headers to capture. Fields are documented below.
 * @property captureOptions Specifies what data to capture. Fields are documented below.
 * @property destinationS3Uri The URL for S3 location where the captured data is stored.
 * @property enableCapture Flag to enable data capture. Defaults to `false`.
 * @property initialSamplingPercentage Portion of data to capture. Should be between 0 and 100.
 * @property kmsKeyId Amazon Resource Name (ARN) of a AWS Key Management Service key that Amazon SageMaker uses to encrypt the captured data on Amazon S3.
 */
public data class EndpointConfigurationDataCaptureConfigArgs(
    public val captureContentTypeHeader:
    Output<EndpointConfigurationDataCaptureConfigCaptureContentTypeHeaderArgs>? = null,
    public val captureOptions: Output<List<EndpointConfigurationDataCaptureConfigCaptureOptionArgs>>,
    public val destinationS3Uri: Output<String>,
    public val enableCapture: Output<Boolean>? = null,
    public val initialSamplingPercentage: Output<Int>,
    public val kmsKeyId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.sagemaker.inputs.EndpointConfigurationDataCaptureConfigArgs> {
    override fun toJava(): com.pulumi.aws.sagemaker.inputs.EndpointConfigurationDataCaptureConfigArgs =
        com.pulumi.aws.sagemaker.inputs.EndpointConfigurationDataCaptureConfigArgs.builder()
            .captureContentTypeHeader(
                captureContentTypeHeader?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .captureOptions(
                captureOptions.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .destinationS3Uri(destinationS3Uri.applyValue({ args0 -> args0 }))
            .enableCapture(enableCapture?.applyValue({ args0 -> args0 }))
            .initialSamplingPercentage(initialSamplingPercentage.applyValue({ args0 -> args0 }))
            .kmsKeyId(kmsKeyId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [EndpointConfigurationDataCaptureConfigArgs].
 */
@PulumiTagMarker
public class EndpointConfigurationDataCaptureConfigArgsBuilder internal constructor() {
    private var captureContentTypeHeader:
        Output<EndpointConfigurationDataCaptureConfigCaptureContentTypeHeaderArgs>? = null

    private var captureOptions: Output<List<EndpointConfigurationDataCaptureConfigCaptureOptionArgs>>? =
        null

    private var destinationS3Uri: Output<String>? = null

    private var enableCapture: Output<Boolean>? = null

    private var initialSamplingPercentage: Output<Int>? = null

    private var kmsKeyId: Output<String>? = null

    /**
     * @param value The content type headers to capture. Fields are documented below.
     */
    @JvmName("wohdrwpcqaprqkwa")
    public suspend
    fun captureContentTypeHeader(`value`: Output<EndpointConfigurationDataCaptureConfigCaptureContentTypeHeaderArgs>) {
        this.captureContentTypeHeader = value
    }

    /**
     * @param value Specifies what data to capture. Fields are documented below.
     */
    @JvmName("dltwxdiusjvpqhur")
    public suspend
    fun captureOptions(`value`: Output<List<EndpointConfigurationDataCaptureConfigCaptureOptionArgs>>) {
        this.captureOptions = value
    }

    @JvmName("ruatxymvcltinljd")
    public suspend fun captureOptions(
        vararg
        values: Output<EndpointConfigurationDataCaptureConfigCaptureOptionArgs>,
    ) {
        this.captureOptions = Output.all(values.asList())
    }

    /**
     * @param values Specifies what data to capture. Fields are documented below.
     */
    @JvmName("salgtfuwmwnaibin")
    public suspend
    fun captureOptions(values: List<Output<EndpointConfigurationDataCaptureConfigCaptureOptionArgs>>) {
        this.captureOptions = Output.all(values)
    }

    /**
     * @param value The URL for S3 location where the captured data is stored.
     */
    @JvmName("xaliqopjymlvyaqr")
    public suspend fun destinationS3Uri(`value`: Output<String>) {
        this.destinationS3Uri = value
    }

    /**
     * @param value Flag to enable data capture. Defaults to `false`.
     */
    @JvmName("igytpmdrjwolhjag")
    public suspend fun enableCapture(`value`: Output<Boolean>) {
        this.enableCapture = value
    }

    /**
     * @param value Portion of data to capture. Should be between 0 and 100.
     */
    @JvmName("cnlcqndokeomiqjg")
    public suspend fun initialSamplingPercentage(`value`: Output<Int>) {
        this.initialSamplingPercentage = value
    }

    /**
     * @param value Amazon Resource Name (ARN) of a AWS Key Management Service key that Amazon SageMaker uses to encrypt the captured data on Amazon S3.
     */
    @JvmName("vcmsaixfmqjkxynv")
    public suspend fun kmsKeyId(`value`: Output<String>) {
        this.kmsKeyId = value
    }

    /**
     * @param value The content type headers to capture. Fields are documented below.
     */
    @JvmName("gcwjbtelkmerhswo")
    public suspend
    fun captureContentTypeHeader(`value`: EndpointConfigurationDataCaptureConfigCaptureContentTypeHeaderArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.captureContentTypeHeader = mapped
    }

    /**
     * @param argument The content type headers to capture. Fields are documented below.
     */
    @JvmName("imsvcoklnsudugea")
    public suspend
    fun captureContentTypeHeader(argument: suspend EndpointConfigurationDataCaptureConfigCaptureContentTypeHeaderArgsBuilder.() -> Unit) {
        val toBeMapped =
            EndpointConfigurationDataCaptureConfigCaptureContentTypeHeaderArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.captureContentTypeHeader = mapped
    }

    /**
     * @param value Specifies what data to capture. Fields are documented below.
     */
    @JvmName("nwtuuksmgbpabfvj")
    public suspend
    fun captureOptions(`value`: List<EndpointConfigurationDataCaptureConfigCaptureOptionArgs>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.captureOptions = mapped
    }

    /**
     * @param argument Specifies what data to capture. Fields are documented below.
     */
    @JvmName("iypstypqcailbajs")
    public suspend
    fun captureOptions(argument: List<suspend EndpointConfigurationDataCaptureConfigCaptureOptionArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            EndpointConfigurationDataCaptureConfigCaptureOptionArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.captureOptions = mapped
    }

    /**
     * @param argument Specifies what data to capture. Fields are documented below.
     */
    @JvmName("luiohokdmkrebfyp")
    public suspend fun captureOptions(
        vararg
        argument: suspend EndpointConfigurationDataCaptureConfigCaptureOptionArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            EndpointConfigurationDataCaptureConfigCaptureOptionArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.captureOptions = mapped
    }

    /**
     * @param argument Specifies what data to capture. Fields are documented below.
     */
    @JvmName("rkqlhmeehweypbjx")
    public suspend
    fun captureOptions(argument: suspend EndpointConfigurationDataCaptureConfigCaptureOptionArgsBuilder.() -> Unit) {
        val toBeMapped =
            listOf(
                EndpointConfigurationDataCaptureConfigCaptureOptionArgsBuilder().applySuspend {
                    argument()
                }.build(),
            )
        val mapped = of(toBeMapped)
        this.captureOptions = mapped
    }

    /**
     * @param values Specifies what data to capture. Fields are documented below.
     */
    @JvmName("gryljrbkcudphckb")
    public suspend fun captureOptions(
        vararg
        values: EndpointConfigurationDataCaptureConfigCaptureOptionArgs,
    ) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.captureOptions = mapped
    }

    /**
     * @param value The URL for S3 location where the captured data is stored.
     */
    @JvmName("pbdlloainmyghrrf")
    public suspend fun destinationS3Uri(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.destinationS3Uri = mapped
    }

    /**
     * @param value Flag to enable data capture. Defaults to `false`.
     */
    @JvmName("yyaqrbgvrtagvamr")
    public suspend fun enableCapture(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enableCapture = mapped
    }

    /**
     * @param value Portion of data to capture. Should be between 0 and 100.
     */
    @JvmName("wulmspgvrkkfcqnm")
    public suspend fun initialSamplingPercentage(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.initialSamplingPercentage = mapped
    }

    /**
     * @param value Amazon Resource Name (ARN) of a AWS Key Management Service key that Amazon SageMaker uses to encrypt the captured data on Amazon S3.
     */
    @JvmName("rajxtlgvbtwieqcl")
    public suspend fun kmsKeyId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kmsKeyId = mapped
    }

    internal fun build(): EndpointConfigurationDataCaptureConfigArgs =
        EndpointConfigurationDataCaptureConfigArgs(
            captureContentTypeHeader = captureContentTypeHeader,
            captureOptions = captureOptions ?: throw PulumiNullFieldException("captureOptions"),
            destinationS3Uri = destinationS3Uri ?: throw PulumiNullFieldException("destinationS3Uri"),
            enableCapture = enableCapture,
            initialSamplingPercentage = initialSamplingPercentage ?: throw
                PulumiNullFieldException("initialSamplingPercentage"),
            kmsKeyId = kmsKeyId,
        )
}
