@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sagemaker.kotlin.inputs

import com.pulumi.aws.sagemaker.inputs.EndpointConfigurationDataCaptureConfigCaptureContentTypeHeaderArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property csvContentTypes The CSV content type headers to capture.
 * @property jsonContentTypes The JSON content type headers to capture.
 */
public data class EndpointConfigurationDataCaptureConfigCaptureContentTypeHeaderArgs(
    public val csvContentTypes: Output<List<String>>? = null,
    public val jsonContentTypes: Output<List<String>>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.sagemaker.inputs.EndpointConfigurationDataCaptureConfigCaptureContentTypeHeaderArgs> {
    override fun toJava():
        com.pulumi.aws.sagemaker.inputs.EndpointConfigurationDataCaptureConfigCaptureContentTypeHeaderArgs =
        com.pulumi.aws.sagemaker.inputs.EndpointConfigurationDataCaptureConfigCaptureContentTypeHeaderArgs.builder()
            .csvContentTypes(csvContentTypes?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .jsonContentTypes(jsonContentTypes?.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [EndpointConfigurationDataCaptureConfigCaptureContentTypeHeaderArgs].
 */
@PulumiTagMarker
public class EndpointConfigurationDataCaptureConfigCaptureContentTypeHeaderArgsBuilder internal
constructor() {
    private var csvContentTypes: Output<List<String>>? = null

    private var jsonContentTypes: Output<List<String>>? = null

    /**
     * @param value The CSV content type headers to capture.
     */
    @JvmName("jkwplxnwmtpamuvm")
    public suspend fun csvContentTypes(`value`: Output<List<String>>) {
        this.csvContentTypes = value
    }

    @JvmName("ogrdqwgrijxtuuop")
    public suspend fun csvContentTypes(vararg values: Output<String>) {
        this.csvContentTypes = Output.all(values.asList())
    }

    /**
     * @param values The CSV content type headers to capture.
     */
    @JvmName("xpkfpexnpcbouygy")
    public suspend fun csvContentTypes(values: List<Output<String>>) {
        this.csvContentTypes = Output.all(values)
    }

    /**
     * @param value The JSON content type headers to capture.
     */
    @JvmName("nijxejglmeolitik")
    public suspend fun jsonContentTypes(`value`: Output<List<String>>) {
        this.jsonContentTypes = value
    }

    @JvmName("vffqspkgqjlgltsi")
    public suspend fun jsonContentTypes(vararg values: Output<String>) {
        this.jsonContentTypes = Output.all(values.asList())
    }

    /**
     * @param values The JSON content type headers to capture.
     */
    @JvmName("povkdmjygnirbewe")
    public suspend fun jsonContentTypes(values: List<Output<String>>) {
        this.jsonContentTypes = Output.all(values)
    }

    /**
     * @param value The CSV content type headers to capture.
     */
    @JvmName("sfihpsbhokjieqfx")
    public suspend fun csvContentTypes(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.csvContentTypes = mapped
    }

    /**
     * @param values The CSV content type headers to capture.
     */
    @JvmName("vuubgoudfyaleone")
    public suspend fun csvContentTypes(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.csvContentTypes = mapped
    }

    /**
     * @param value The JSON content type headers to capture.
     */
    @JvmName("yjtbkjddqidcxjjj")
    public suspend fun jsonContentTypes(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.jsonContentTypes = mapped
    }

    /**
     * @param values The JSON content type headers to capture.
     */
    @JvmName("bpdnvgcyepdoasla")
    public suspend fun jsonContentTypes(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.jsonContentTypes = mapped
    }

    internal fun build(): EndpointConfigurationDataCaptureConfigCaptureContentTypeHeaderArgs =
        EndpointConfigurationDataCaptureConfigCaptureContentTypeHeaderArgs(
            csvContentTypes = csvContentTypes,
            jsonContentTypes = jsonContentTypes,
        )
}
