@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sagemaker.kotlin.inputs

import com.pulumi.aws.sagemaker.inputs.EndpointConfigurationDataCaptureConfigCaptureOptionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property captureMode Specifies the data to be captured. Should be one of `Input` or `Output`.
 */
public data class EndpointConfigurationDataCaptureConfigCaptureOptionArgs(
    public val captureMode: Output<String>,
) :
    ConvertibleToJava<com.pulumi.aws.sagemaker.inputs.EndpointConfigurationDataCaptureConfigCaptureOptionArgs> {
    override fun toJava():
        com.pulumi.aws.sagemaker.inputs.EndpointConfigurationDataCaptureConfigCaptureOptionArgs =
        com.pulumi.aws.sagemaker.inputs.EndpointConfigurationDataCaptureConfigCaptureOptionArgs.builder()
            .captureMode(captureMode.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [EndpointConfigurationDataCaptureConfigCaptureOptionArgs].
 */
@PulumiTagMarker
public class EndpointConfigurationDataCaptureConfigCaptureOptionArgsBuilder internal constructor() {
    private var captureMode: Output<String>? = null

    /**
     * @param value Specifies the data to be captured. Should be one of `Input` or `Output`.
     */
    @JvmName("fbqbkvnsjinphkrg")
    public suspend fun captureMode(`value`: Output<String>) {
        this.captureMode = value
    }

    /**
     * @param value Specifies the data to be captured. Should be one of `Input` or `Output`.
     */
    @JvmName("enlpnnrkjsiggeba")
    public suspend fun captureMode(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.captureMode = mapped
    }

    internal fun build(): EndpointConfigurationDataCaptureConfigCaptureOptionArgs =
        EndpointConfigurationDataCaptureConfigCaptureOptionArgs(
            captureMode = captureMode ?: throw PulumiNullFieldException("captureMode"),
        )
}
