@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sagemaker.kotlin.inputs

import com.pulumi.aws.sagemaker.inputs.EndpointConfigurationProductionVariantCoreDumpConfigArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property destinationS3Uri The Amazon S3 bucket to send the core dump to.
 * @property kmsKeyId The Amazon Web Services Key Management Service (Amazon Web Services KMS) key that SageMaker uses to encrypt the core dump data at rest using Amazon S3 server-side encryption.
 */
public data class EndpointConfigurationProductionVariantCoreDumpConfigArgs(
    public val destinationS3Uri: Output<String>,
    public val kmsKeyId: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.sagemaker.inputs.EndpointConfigurationProductionVariantCoreDumpConfigArgs> {
    override fun toJava():
        com.pulumi.aws.sagemaker.inputs.EndpointConfigurationProductionVariantCoreDumpConfigArgs =
        com.pulumi.aws.sagemaker.inputs.EndpointConfigurationProductionVariantCoreDumpConfigArgs.builder()
            .destinationS3Uri(destinationS3Uri.applyValue({ args0 -> args0 }))
            .kmsKeyId(kmsKeyId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [EndpointConfigurationProductionVariantCoreDumpConfigArgs].
 */
@PulumiTagMarker
public class EndpointConfigurationProductionVariantCoreDumpConfigArgsBuilder internal constructor() {
    private var destinationS3Uri: Output<String>? = null

    private var kmsKeyId: Output<String>? = null

    /**
     * @param value The Amazon S3 bucket to send the core dump to.
     */
    @JvmName("krroikqmhivgnlui")
    public suspend fun destinationS3Uri(`value`: Output<String>) {
        this.destinationS3Uri = value
    }

    /**
     * @param value The Amazon Web Services Key Management Service (Amazon Web Services KMS) key that SageMaker uses to encrypt the core dump data at rest using Amazon S3 server-side encryption.
     */
    @JvmName("twklexsufguihuyr")
    public suspend fun kmsKeyId(`value`: Output<String>) {
        this.kmsKeyId = value
    }

    /**
     * @param value The Amazon S3 bucket to send the core dump to.
     */
    @JvmName("wamlyqyrxkxyipui")
    public suspend fun destinationS3Uri(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.destinationS3Uri = mapped
    }

    /**
     * @param value The Amazon Web Services Key Management Service (Amazon Web Services KMS) key that SageMaker uses to encrypt the core dump data at rest using Amazon S3 server-side encryption.
     */
    @JvmName("juwgpwfeqabuvdle")
    public suspend fun kmsKeyId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kmsKeyId = mapped
    }

    internal fun build(): EndpointConfigurationProductionVariantCoreDumpConfigArgs =
        EndpointConfigurationProductionVariantCoreDumpConfigArgs(
            destinationS3Uri = destinationS3Uri ?: throw PulumiNullFieldException("destinationS3Uri"),
            kmsKeyId = kmsKeyId,
        )
}
