@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sagemaker.kotlin.inputs

import com.pulumi.aws.sagemaker.inputs.EndpointConfigurationShadowProductionVariantArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Double
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property acceleratorType The size of the Elastic Inference (EI) instance to use for the production variant.
 * @property containerStartupHealthCheckTimeoutInSeconds The timeout value, in seconds, for your inference container to pass health check by SageMaker Hosting. For more information about health check, see [How Your Container Should Respond to Health Check (Ping) Requests](https://docs.aws.amazon.com/sagemaker/latest/dg/your-algorithms-inference-code.html#your-algorithms-inference-algo-ping-requests). Valid values between `60` and `3600`.
 * @property coreDumpConfig Specifies configuration for a core dump from the model container when the process crashes. Fields are documented below.
 * @property enableSsmAccess You can use this parameter to turn on native Amazon Web Services Systems Manager (SSM) access for a production variant behind an endpoint. By default, SSM access is disabled for all production variants behind an endpoints.
 * @property initialInstanceCount Initial number of instances used for auto-scaling.
 * @property initialVariantWeight Determines initial traffic distribution among all of the models that you specify in the endpoint configuration. If unspecified, it defaults to `1.0`.
 * @property instanceType The type of instance to start.
 * @property modelDataDownloadTimeoutInSeconds The timeout value, in seconds, to download and extract the model that you want to host from Amazon S3 to the individual inference instance associated with this production variant. Valid values between `60` and `3600`.
 * @property modelName The name of the model to use.
 * @property serverlessConfig Specifies configuration for how an endpoint performs asynchronous inference.
 * @property variantName The name of the variant. If omitted, this provider will assign a random, unique name.
 * @property volumeSizeInGb The size, in GB, of the ML storage volume attached to individual inference instance associated with the production variant. Valid values between `1` and `512`.
 */
public data class EndpointConfigurationShadowProductionVariantArgs(
    public val acceleratorType: Output<String>? = null,
    public val containerStartupHealthCheckTimeoutInSeconds: Output<Int>? = null,
    public val coreDumpConfig: Output<EndpointConfigurationShadowProductionVariantCoreDumpConfigArgs>? =
        null,
    public val enableSsmAccess: Output<Boolean>? = null,
    public val initialInstanceCount: Output<Int>? = null,
    public val initialVariantWeight: Output<Double>? = null,
    public val instanceType: Output<String>? = null,
    public val modelDataDownloadTimeoutInSeconds: Output<Int>? = null,
    public val modelName: Output<String>,
    public val serverlessConfig:
    Output<EndpointConfigurationShadowProductionVariantServerlessConfigArgs>? = null,
    public val variantName: Output<String>? = null,
    public val volumeSizeInGb: Output<Int>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.sagemaker.inputs.EndpointConfigurationShadowProductionVariantArgs> {
    override fun toJava():
        com.pulumi.aws.sagemaker.inputs.EndpointConfigurationShadowProductionVariantArgs =
        com.pulumi.aws.sagemaker.inputs.EndpointConfigurationShadowProductionVariantArgs.builder()
            .acceleratorType(acceleratorType?.applyValue({ args0 -> args0 }))
            .containerStartupHealthCheckTimeoutInSeconds(
                containerStartupHealthCheckTimeoutInSeconds?.applyValue({ args0 ->
                    args0
                }),
            )
            .coreDumpConfig(coreDumpConfig?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .enableSsmAccess(enableSsmAccess?.applyValue({ args0 -> args0 }))
            .initialInstanceCount(initialInstanceCount?.applyValue({ args0 -> args0 }))
            .initialVariantWeight(initialVariantWeight?.applyValue({ args0 -> args0 }))
            .instanceType(instanceType?.applyValue({ args0 -> args0 }))
            .modelDataDownloadTimeoutInSeconds(
                modelDataDownloadTimeoutInSeconds?.applyValue({ args0 ->
                    args0
                }),
            )
            .modelName(modelName.applyValue({ args0 -> args0 }))
            .serverlessConfig(serverlessConfig?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .variantName(variantName?.applyValue({ args0 -> args0 }))
            .volumeSizeInGb(volumeSizeInGb?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [EndpointConfigurationShadowProductionVariantArgs].
 */
@PulumiTagMarker
public class EndpointConfigurationShadowProductionVariantArgsBuilder internal constructor() {
    private var acceleratorType: Output<String>? = null

    private var containerStartupHealthCheckTimeoutInSeconds: Output<Int>? = null

    private var coreDumpConfig:
        Output<EndpointConfigurationShadowProductionVariantCoreDumpConfigArgs>? = null

    private var enableSsmAccess: Output<Boolean>? = null

    private var initialInstanceCount: Output<Int>? = null

    private var initialVariantWeight: Output<Double>? = null

    private var instanceType: Output<String>? = null

    private var modelDataDownloadTimeoutInSeconds: Output<Int>? = null

    private var modelName: Output<String>? = null

    private var serverlessConfig:
        Output<EndpointConfigurationShadowProductionVariantServerlessConfigArgs>? = null

    private var variantName: Output<String>? = null

    private var volumeSizeInGb: Output<Int>? = null

    /**
     * @param value The size of the Elastic Inference (EI) instance to use for the production variant.
     */
    @JvmName("jahyvamsptsqgsdy")
    public suspend fun acceleratorType(`value`: Output<String>) {
        this.acceleratorType = value
    }

    /**
     * @param value The timeout value, in seconds, for your inference container to pass health check by SageMaker Hosting. For more information about health check, see [How Your Container Should Respond to Health Check (Ping) Requests](https://docs.aws.amazon.com/sagemaker/latest/dg/your-algorithms-inference-code.html#your-algorithms-inference-algo-ping-requests). Valid values between `60` and `3600`.
     */
    @JvmName("dwtgbrqlfgsraxut")
    public suspend fun containerStartupHealthCheckTimeoutInSeconds(`value`: Output<Int>) {
        this.containerStartupHealthCheckTimeoutInSeconds = value
    }

    /**
     * @param value Specifies configuration for a core dump from the model container when the process crashes. Fields are documented below.
     */
    @JvmName("skekynntystvdgbx")
    public suspend
    fun coreDumpConfig(`value`: Output<EndpointConfigurationShadowProductionVariantCoreDumpConfigArgs>) {
        this.coreDumpConfig = value
    }

    /**
     * @param value You can use this parameter to turn on native Amazon Web Services Systems Manager (SSM) access for a production variant behind an endpoint. By default, SSM access is disabled for all production variants behind an endpoints.
     */
    @JvmName("rxhyagxahgwigygh")
    public suspend fun enableSsmAccess(`value`: Output<Boolean>) {
        this.enableSsmAccess = value
    }

    /**
     * @param value Initial number of instances used for auto-scaling.
     */
    @JvmName("toilhafecfngrkmh")
    public suspend fun initialInstanceCount(`value`: Output<Int>) {
        this.initialInstanceCount = value
    }

    /**
     * @param value Determines initial traffic distribution among all of the models that you specify in the endpoint configuration. If unspecified, it defaults to `1.0`.
     */
    @JvmName("qwuasbmjuwtvefkj")
    public suspend fun initialVariantWeight(`value`: Output<Double>) {
        this.initialVariantWeight = value
    }

    /**
     * @param value The type of instance to start.
     */
    @JvmName("xdspjnnadfwarheq")
    public suspend fun instanceType(`value`: Output<String>) {
        this.instanceType = value
    }

    /**
     * @param value The timeout value, in seconds, to download and extract the model that you want to host from Amazon S3 to the individual inference instance associated with this production variant. Valid values between `60` and `3600`.
     */
    @JvmName("cxjoilsbqswvwhfg")
    public suspend fun modelDataDownloadTimeoutInSeconds(`value`: Output<Int>) {
        this.modelDataDownloadTimeoutInSeconds = value
    }

    /**
     * @param value The name of the model to use.
     */
    @JvmName("tivfhourcihmutju")
    public suspend fun modelName(`value`: Output<String>) {
        this.modelName = value
    }

    /**
     * @param value Specifies configuration for how an endpoint performs asynchronous inference.
     */
    @JvmName("orvpnnmkilmkrogy")
    public suspend
    fun serverlessConfig(`value`: Output<EndpointConfigurationShadowProductionVariantServerlessConfigArgs>) {
        this.serverlessConfig = value
    }

    /**
     * @param value The name of the variant. If omitted, this provider will assign a random, unique name.
     */
    @JvmName("wvpsepaccewmtkku")
    public suspend fun variantName(`value`: Output<String>) {
        this.variantName = value
    }

    /**
     * @param value The size, in GB, of the ML storage volume attached to individual inference instance associated with the production variant. Valid values between `1` and `512`.
     */
    @JvmName("iwemcudsvibqmckw")
    public suspend fun volumeSizeInGb(`value`: Output<Int>) {
        this.volumeSizeInGb = value
    }

    /**
     * @param value The size of the Elastic Inference (EI) instance to use for the production variant.
     */
    @JvmName("kcxwwddxyioyxjjg")
    public suspend fun acceleratorType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.acceleratorType = mapped
    }

    /**
     * @param value The timeout value, in seconds, for your inference container to pass health check by SageMaker Hosting. For more information about health check, see [How Your Container Should Respond to Health Check (Ping) Requests](https://docs.aws.amazon.com/sagemaker/latest/dg/your-algorithms-inference-code.html#your-algorithms-inference-algo-ping-requests). Valid values between `60` and `3600`.
     */
    @JvmName("ojbkrkyeqvctxrjf")
    public suspend fun containerStartupHealthCheckTimeoutInSeconds(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.containerStartupHealthCheckTimeoutInSeconds = mapped
    }

    /**
     * @param value Specifies configuration for a core dump from the model container when the process crashes. Fields are documented below.
     */
    @JvmName("vfaqeltyktuermbe")
    public suspend
    fun coreDumpConfig(`value`: EndpointConfigurationShadowProductionVariantCoreDumpConfigArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.coreDumpConfig = mapped
    }

    /**
     * @param argument Specifies configuration for a core dump from the model container when the process crashes. Fields are documented below.
     */
    @JvmName("utdmesernsowfpro")
    public suspend
    fun coreDumpConfig(argument: suspend EndpointConfigurationShadowProductionVariantCoreDumpConfigArgsBuilder.() -> Unit) {
        val toBeMapped =
            EndpointConfigurationShadowProductionVariantCoreDumpConfigArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.coreDumpConfig = mapped
    }

    /**
     * @param value You can use this parameter to turn on native Amazon Web Services Systems Manager (SSM) access for a production variant behind an endpoint. By default, SSM access is disabled for all production variants behind an endpoints.
     */
    @JvmName("yfaqlusspiaiifvh")
    public suspend fun enableSsmAccess(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enableSsmAccess = mapped
    }

    /**
     * @param value Initial number of instances used for auto-scaling.
     */
    @JvmName("rmrrdwqegqjiihpj")
    public suspend fun initialInstanceCount(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.initialInstanceCount = mapped
    }

    /**
     * @param value Determines initial traffic distribution among all of the models that you specify in the endpoint configuration. If unspecified, it defaults to `1.0`.
     */
    @JvmName("xdcmhgergavnndox")
    public suspend fun initialVariantWeight(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.initialVariantWeight = mapped
    }

    /**
     * @param value The type of instance to start.
     */
    @JvmName("behfnkiqendvhsmw")
    public suspend fun instanceType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.instanceType = mapped
    }

    /**
     * @param value The timeout value, in seconds, to download and extract the model that you want to host from Amazon S3 to the individual inference instance associated with this production variant. Valid values between `60` and `3600`.
     */
    @JvmName("nmgrdqgmbhifbfmv")
    public suspend fun modelDataDownloadTimeoutInSeconds(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.modelDataDownloadTimeoutInSeconds = mapped
    }

    /**
     * @param value The name of the model to use.
     */
    @JvmName("kiqhbmtitpuyiqfx")
    public suspend fun modelName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.modelName = mapped
    }

    /**
     * @param value Specifies configuration for how an endpoint performs asynchronous inference.
     */
    @JvmName("kadpygjmgywauqhw")
    public suspend
    fun serverlessConfig(`value`: EndpointConfigurationShadowProductionVariantServerlessConfigArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serverlessConfig = mapped
    }

    /**
     * @param argument Specifies configuration for how an endpoint performs asynchronous inference.
     */
    @JvmName("ygrgrrdborlsubwi")
    public suspend
    fun serverlessConfig(argument: suspend EndpointConfigurationShadowProductionVariantServerlessConfigArgsBuilder.() -> Unit) {
        val toBeMapped =
            EndpointConfigurationShadowProductionVariantServerlessConfigArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.serverlessConfig = mapped
    }

    /**
     * @param value The name of the variant. If omitted, this provider will assign a random, unique name.
     */
    @JvmName("lubobhgodrmnbwto")
    public suspend fun variantName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.variantName = mapped
    }

    /**
     * @param value The size, in GB, of the ML storage volume attached to individual inference instance associated with the production variant. Valid values between `1` and `512`.
     */
    @JvmName("ypytfmvklkgytsfc")
    public suspend fun volumeSizeInGb(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.volumeSizeInGb = mapped
    }

    internal fun build(): EndpointConfigurationShadowProductionVariantArgs =
        EndpointConfigurationShadowProductionVariantArgs(
            acceleratorType = acceleratorType,
            containerStartupHealthCheckTimeoutInSeconds = containerStartupHealthCheckTimeoutInSeconds,
            coreDumpConfig = coreDumpConfig,
            enableSsmAccess = enableSsmAccess,
            initialInstanceCount = initialInstanceCount,
            initialVariantWeight = initialVariantWeight,
            instanceType = instanceType,
            modelDataDownloadTimeoutInSeconds = modelDataDownloadTimeoutInSeconds,
            modelName = modelName ?: throw PulumiNullFieldException("modelName"),
            serverlessConfig = serverlessConfig,
            variantName = variantName,
            volumeSizeInGb = volumeSizeInGb,
        )
}
