@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sagemaker.kotlin.inputs

import com.pulumi.aws.sagemaker.inputs.EndpointConfigurationShadowProductionVariantServerlessConfigArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property maxConcurrency The maximum number of concurrent invocations your serverless endpoint can process. Valid values are between `1` and `200`.
 * @property memorySizeInMb The memory size of your serverless endpoint. Valid values are in 1 GB increments: `1024` MB, `2048` MB, `3072` MB, `4096` MB, `5120` MB, or `6144` MB.
 * @property provisionedConcurrency The amount of provisioned concurrency to allocate for the serverless endpoint. Should be less than or equal to `max_concurrency`. Valid values are between `1` and `200`.
 */
public data class EndpointConfigurationShadowProductionVariantServerlessConfigArgs(
    public val maxConcurrency: Output<Int>,
    public val memorySizeInMb: Output<Int>,
    public val provisionedConcurrency: Output<Int>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.sagemaker.inputs.EndpointConfigurationShadowProductionVariantServerlessConfigArgs> {
    override fun toJava():
        com.pulumi.aws.sagemaker.inputs.EndpointConfigurationShadowProductionVariantServerlessConfigArgs =
        com.pulumi.aws.sagemaker.inputs.EndpointConfigurationShadowProductionVariantServerlessConfigArgs.builder()
            .maxConcurrency(maxConcurrency.applyValue({ args0 -> args0 }))
            .memorySizeInMb(memorySizeInMb.applyValue({ args0 -> args0 }))
            .provisionedConcurrency(provisionedConcurrency?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [EndpointConfigurationShadowProductionVariantServerlessConfigArgs].
 */
@PulumiTagMarker
public class EndpointConfigurationShadowProductionVariantServerlessConfigArgsBuilder internal
constructor() {
    private var maxConcurrency: Output<Int>? = null

    private var memorySizeInMb: Output<Int>? = null

    private var provisionedConcurrency: Output<Int>? = null

    /**
     * @param value The maximum number of concurrent invocations your serverless endpoint can process. Valid values are between `1` and `200`.
     */
    @JvmName("xcmryojqqfttsgve")
    public suspend fun maxConcurrency(`value`: Output<Int>) {
        this.maxConcurrency = value
    }

    /**
     * @param value The memory size of your serverless endpoint. Valid values are in 1 GB increments: `1024` MB, `2048` MB, `3072` MB, `4096` MB, `5120` MB, or `6144` MB.
     */
    @JvmName("ddackkoudlsdpeml")
    public suspend fun memorySizeInMb(`value`: Output<Int>) {
        this.memorySizeInMb = value
    }

    /**
     * @param value The amount of provisioned concurrency to allocate for the serverless endpoint. Should be less than or equal to `max_concurrency`. Valid values are between `1` and `200`.
     */
    @JvmName("qgqumolllwmopoem")
    public suspend fun provisionedConcurrency(`value`: Output<Int>) {
        this.provisionedConcurrency = value
    }

    /**
     * @param value The maximum number of concurrent invocations your serverless endpoint can process. Valid values are between `1` and `200`.
     */
    @JvmName("wgcnqcaxktaolyry")
    public suspend fun maxConcurrency(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.maxConcurrency = mapped
    }

    /**
     * @param value The memory size of your serverless endpoint. Valid values are in 1 GB increments: `1024` MB, `2048` MB, `3072` MB, `4096` MB, `5120` MB, or `6144` MB.
     */
    @JvmName("mppbdeqpshydcjhw")
    public suspend fun memorySizeInMb(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.memorySizeInMb = mapped
    }

    /**
     * @param value The amount of provisioned concurrency to allocate for the serverless endpoint. Should be less than or equal to `max_concurrency`. Valid values are between `1` and `200`.
     */
    @JvmName("bvbhcxevlupcesmn")
    public suspend fun provisionedConcurrency(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.provisionedConcurrency = mapped
    }

    internal fun build(): EndpointConfigurationShadowProductionVariantServerlessConfigArgs =
        EndpointConfigurationShadowProductionVariantServerlessConfigArgs(
            maxConcurrency = maxConcurrency ?: throw PulumiNullFieldException("maxConcurrency"),
            memorySizeInMb = memorySizeInMb ?: throw PulumiNullFieldException("memorySizeInMb"),
            provisionedConcurrency = provisionedConcurrency,
        )
}
