@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sagemaker.kotlin.inputs

import com.pulumi.aws.sagemaker.inputs.EndpointDeploymentConfigRollingUpdatePolicyRollbackMaximumBatchSizeArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property type Specifies the endpoint capacity type. Valid values are: `INSTANCE_COUNT`, or `CAPACITY_PERCENT`.
 * @property value Defines the capacity size, either as a number of instances or a capacity percentage.
 */
public data class EndpointDeploymentConfigRollingUpdatePolicyRollbackMaximumBatchSizeArgs(
    public val type: Output<String>,
    public val `value`: Output<Int>,
) :
    ConvertibleToJava<com.pulumi.aws.sagemaker.inputs.EndpointDeploymentConfigRollingUpdatePolicyRollbackMaximumBatchSizeArgs> {
    override fun toJava():
        com.pulumi.aws.sagemaker.inputs.EndpointDeploymentConfigRollingUpdatePolicyRollbackMaximumBatchSizeArgs =
        com.pulumi.aws.sagemaker.inputs.EndpointDeploymentConfigRollingUpdatePolicyRollbackMaximumBatchSizeArgs.builder()
            .type(type.applyValue({ args0 -> args0 }))
            .`value`(`value`.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [EndpointDeploymentConfigRollingUpdatePolicyRollbackMaximumBatchSizeArgs].
 */
@PulumiTagMarker
public class EndpointDeploymentConfigRollingUpdatePolicyRollbackMaximumBatchSizeArgsBuilder internal
constructor() {
    private var type: Output<String>? = null

    private var `value`: Output<Int>? = null

    /**
     * @param value Specifies the endpoint capacity type. Valid values are: `INSTANCE_COUNT`, or `CAPACITY_PERCENT`.
     */
    @JvmName("gbmskuhordtplosb")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value Defines the capacity size, either as a number of instances or a capacity percentage.
     */
    @JvmName("owavurbakkxtwoks")
    public suspend fun `value`(`value`: Output<Int>) {
        this.`value` = value
    }

    /**
     * @param value Specifies the endpoint capacity type. Valid values are: `INSTANCE_COUNT`, or `CAPACITY_PERCENT`.
     */
    @JvmName("hfuyxmhfgqkpoyml")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value Defines the capacity size, either as a number of instances or a capacity percentage.
     */
    @JvmName("lvjosarqgcmdotbg")
    public suspend fun `value`(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.`value` = mapped
    }

    internal fun build(): EndpointDeploymentConfigRollingUpdatePolicyRollbackMaximumBatchSizeArgs =
        EndpointDeploymentConfigRollingUpdatePolicyRollbackMaximumBatchSizeArgs(
            type = type ?: throw PulumiNullFieldException("type"),
            `value` = `value` ?: throw PulumiNullFieldException("value"),
        )
}
