@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sagemaker.kotlin.inputs

import com.pulumi.aws.sagemaker.inputs.FeatureGroupOfflineStoreConfigDataCatalogConfigArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property catalog The name of the Glue table catalog.
 * @property database The name of the Glue table database.
 * @property tableName The name of the Glue table.
 */
public data class FeatureGroupOfflineStoreConfigDataCatalogConfigArgs(
    public val catalog: Output<String>? = null,
    public val database: Output<String>? = null,
    public val tableName: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.sagemaker.inputs.FeatureGroupOfflineStoreConfigDataCatalogConfigArgs> {
    override fun toJava():
        com.pulumi.aws.sagemaker.inputs.FeatureGroupOfflineStoreConfigDataCatalogConfigArgs =
        com.pulumi.aws.sagemaker.inputs.FeatureGroupOfflineStoreConfigDataCatalogConfigArgs.builder()
            .catalog(catalog?.applyValue({ args0 -> args0 }))
            .database(database?.applyValue({ args0 -> args0 }))
            .tableName(tableName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [FeatureGroupOfflineStoreConfigDataCatalogConfigArgs].
 */
@PulumiTagMarker
public class FeatureGroupOfflineStoreConfigDataCatalogConfigArgsBuilder internal constructor() {
    private var catalog: Output<String>? = null

    private var database: Output<String>? = null

    private var tableName: Output<String>? = null

    /**
     * @param value The name of the Glue table catalog.
     */
    @JvmName("dtycnulbmoblucjj")
    public suspend fun catalog(`value`: Output<String>) {
        this.catalog = value
    }

    /**
     * @param value The name of the Glue table database.
     */
    @JvmName("bgkntpjjhwqliral")
    public suspend fun database(`value`: Output<String>) {
        this.database = value
    }

    /**
     * @param value The name of the Glue table.
     */
    @JvmName("luuaptjwlpkmwkfs")
    public suspend fun tableName(`value`: Output<String>) {
        this.tableName = value
    }

    /**
     * @param value The name of the Glue table catalog.
     */
    @JvmName("caoatrlmvhbimsxi")
    public suspend fun catalog(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.catalog = mapped
    }

    /**
     * @param value The name of the Glue table database.
     */
    @JvmName("ysvsfkfkwyrkesjt")
    public suspend fun database(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.database = mapped
    }

    /**
     * @param value The name of the Glue table.
     */
    @JvmName("aqdvbiehcuixnnth")
    public suspend fun tableName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tableName = mapped
    }

    internal fun build(): FeatureGroupOfflineStoreConfigDataCatalogConfigArgs =
        FeatureGroupOfflineStoreConfigDataCatalogConfigArgs(
            catalog = catalog,
            database = database,
            tableName = tableName,
        )
}
