@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sagemaker.kotlin.inputs

import com.pulumi.aws.sagemaker.inputs.FeatureGroupOnlineStoreConfigSecurityConfigArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property kmsKeyId The ID of the AWS Key Management Service (AWS KMS) key that SageMaker Feature Store uses to encrypt the Amazon S3 objects at rest using Amazon S3 server-side encryption.
 */
public data class FeatureGroupOnlineStoreConfigSecurityConfigArgs(
    public val kmsKeyId: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.sagemaker.inputs.FeatureGroupOnlineStoreConfigSecurityConfigArgs> {
    override fun toJava():
        com.pulumi.aws.sagemaker.inputs.FeatureGroupOnlineStoreConfigSecurityConfigArgs =
        com.pulumi.aws.sagemaker.inputs.FeatureGroupOnlineStoreConfigSecurityConfigArgs.builder()
            .kmsKeyId(kmsKeyId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [FeatureGroupOnlineStoreConfigSecurityConfigArgs].
 */
@PulumiTagMarker
public class FeatureGroupOnlineStoreConfigSecurityConfigArgsBuilder internal constructor() {
    private var kmsKeyId: Output<String>? = null

    /**
     * @param value The ID of the AWS Key Management Service (AWS KMS) key that SageMaker Feature Store uses to encrypt the Amazon S3 objects at rest using Amazon S3 server-side encryption.
     */
    @JvmName("ilqppdonjqrqanle")
    public suspend fun kmsKeyId(`value`: Output<String>) {
        this.kmsKeyId = value
    }

    /**
     * @param value The ID of the AWS Key Management Service (AWS KMS) key that SageMaker Feature Store uses to encrypt the Amazon S3 objects at rest using Amazon S3 server-side encryption.
     */
    @JvmName("mrdviftxuvqcihxi")
    public suspend fun kmsKeyId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kmsKeyId = mapped
    }

    internal fun build(): FeatureGroupOnlineStoreConfigSecurityConfigArgs =
        FeatureGroupOnlineStoreConfigSecurityConfigArgs(
            kmsKeyId = kmsKeyId,
        )
}
