@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sagemaker.kotlin.inputs

import com.pulumi.aws.sagemaker.inputs.FlowDefinitionHumanLoopActivationConfigHumanLoopActivationConditionsConfigArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property humanLoopActivationConditions A JSON expressing use-case specific conditions declaratively. If any condition is matched, atomic tasks are created against the configured work team. For more information about how to structure the JSON, see [JSON Schema for Human Loop Activation Conditions in Amazon Augmented AI](https://docs.aws.amazon.com/sagemaker/latest/dg/a2i-human-fallback-conditions-json-schema.html).
 */
public data class FlowDefinitionHumanLoopActivationConfigHumanLoopActivationConditionsConfigArgs(
    public val humanLoopActivationConditions: Output<String>,
) :
    ConvertibleToJava<com.pulumi.aws.sagemaker.inputs.FlowDefinitionHumanLoopActivationConfigHumanLoopActivationConditionsConfigArgs> {
    override fun toJava():
        com.pulumi.aws.sagemaker.inputs.FlowDefinitionHumanLoopActivationConfigHumanLoopActivationConditionsConfigArgs =
        com.pulumi.aws.sagemaker.inputs.FlowDefinitionHumanLoopActivationConfigHumanLoopActivationConditionsConfigArgs.builder()
            .humanLoopActivationConditions(humanLoopActivationConditions.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [FlowDefinitionHumanLoopActivationConfigHumanLoopActivationConditionsConfigArgs].
 */
@PulumiTagMarker
public class FlowDefinitionHumanLoopActivationConfigHumanLoopActivationConditionsConfigArgsBuilder
internal constructor() {
    private var humanLoopActivationConditions: Output<String>? = null

    /**
     * @param value A JSON expressing use-case specific conditions declaratively. If any condition is matched, atomic tasks are created against the configured work team. For more information about how to structure the JSON, see [JSON Schema for Human Loop Activation Conditions in Amazon Augmented AI](https://docs.aws.amazon.com/sagemaker/latest/dg/a2i-human-fallback-conditions-json-schema.html).
     */
    @JvmName("ccgivuctwhofrqvq")
    public suspend fun humanLoopActivationConditions(`value`: Output<String>) {
        this.humanLoopActivationConditions = value
    }

    /**
     * @param value A JSON expressing use-case specific conditions declaratively. If any condition is matched, atomic tasks are created against the configured work team. For more information about how to structure the JSON, see [JSON Schema for Human Loop Activation Conditions in Amazon Augmented AI](https://docs.aws.amazon.com/sagemaker/latest/dg/a2i-human-fallback-conditions-json-schema.html).
     */
    @JvmName("ssekloouysjmmiqe")
    public suspend fun humanLoopActivationConditions(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.humanLoopActivationConditions = mapped
    }

    internal fun build():
        FlowDefinitionHumanLoopActivationConfigHumanLoopActivationConditionsConfigArgs =
        FlowDefinitionHumanLoopActivationConfigHumanLoopActivationConditionsConfigArgs(
            humanLoopActivationConditions = humanLoopActivationConditions ?: throw
                PulumiNullFieldException("humanLoopActivationConditions"),
        )
}
