@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sagemaker.kotlin.inputs

import com.pulumi.aws.sagemaker.inputs.FlowDefinitionHumanLoopConfigArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property humanTaskUiArn The Amazon Resource Name (ARN) of the human task user interface.
 * @property publicWorkforceTaskPrice Defines the amount of money paid to an Amazon Mechanical Turk worker for each task performed. See Public Workforce Task Price details below.
 * @property taskAvailabilityLifetimeInSeconds The length of time that a task remains available for review by human workers. Valid value range between `1` and `864000`.
 * @property taskCount The number of distinct workers who will perform the same task on each object. Valid value range between `1` and `3`.
 * @property taskDescription A description for the human worker task.
 * @property taskKeywords An array of keywords used to describe the task so that workers can discover the task.
 * @property taskTimeLimitInSeconds The amount of time that a worker has to complete a task. The default value is `3600` seconds.
 * @property taskTitle A title for the human worker task.
 * @property workteamArn The Amazon Resource Name (ARN) of the human task user interface. Amazon Resource Name (ARN) of a team of workers. For Public workforces see [AWS Docs](https://docs.aws.amazon.com/sagemaker/latest/dg/sms-workforce-management-public.html).
 */
public data class FlowDefinitionHumanLoopConfigArgs(
    public val humanTaskUiArn: Output<String>,
    public val publicWorkforceTaskPrice:
    Output<FlowDefinitionHumanLoopConfigPublicWorkforceTaskPriceArgs>? = null,
    public val taskAvailabilityLifetimeInSeconds: Output<Int>? = null,
    public val taskCount: Output<Int>,
    public val taskDescription: Output<String>,
    public val taskKeywords: Output<List<String>>? = null,
    public val taskTimeLimitInSeconds: Output<Int>? = null,
    public val taskTitle: Output<String>,
    public val workteamArn: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.sagemaker.inputs.FlowDefinitionHumanLoopConfigArgs> {
    override fun toJava(): com.pulumi.aws.sagemaker.inputs.FlowDefinitionHumanLoopConfigArgs =
        com.pulumi.aws.sagemaker.inputs.FlowDefinitionHumanLoopConfigArgs.builder()
            .humanTaskUiArn(humanTaskUiArn.applyValue({ args0 -> args0 }))
            .publicWorkforceTaskPrice(
                publicWorkforceTaskPrice?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .taskAvailabilityLifetimeInSeconds(
                taskAvailabilityLifetimeInSeconds?.applyValue({ args0 ->
                    args0
                }),
            )
            .taskCount(taskCount.applyValue({ args0 -> args0 }))
            .taskDescription(taskDescription.applyValue({ args0 -> args0 }))
            .taskKeywords(taskKeywords?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .taskTimeLimitInSeconds(taskTimeLimitInSeconds?.applyValue({ args0 -> args0 }))
            .taskTitle(taskTitle.applyValue({ args0 -> args0 }))
            .workteamArn(workteamArn.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [FlowDefinitionHumanLoopConfigArgs].
 */
@PulumiTagMarker
public class FlowDefinitionHumanLoopConfigArgsBuilder internal constructor() {
    private var humanTaskUiArn: Output<String>? = null

    private var publicWorkforceTaskPrice:
        Output<FlowDefinitionHumanLoopConfigPublicWorkforceTaskPriceArgs>? = null

    private var taskAvailabilityLifetimeInSeconds: Output<Int>? = null

    private var taskCount: Output<Int>? = null

    private var taskDescription: Output<String>? = null

    private var taskKeywords: Output<List<String>>? = null

    private var taskTimeLimitInSeconds: Output<Int>? = null

    private var taskTitle: Output<String>? = null

    private var workteamArn: Output<String>? = null

    /**
     * @param value The Amazon Resource Name (ARN) of the human task user interface.
     */
    @JvmName("ufjqgrvcjxxsfdfc")
    public suspend fun humanTaskUiArn(`value`: Output<String>) {
        this.humanTaskUiArn = value
    }

    /**
     * @param value Defines the amount of money paid to an Amazon Mechanical Turk worker for each task performed. See Public Workforce Task Price details below.
     */
    @JvmName("bxdvsgoxilxelwev")
    public suspend
    fun publicWorkforceTaskPrice(`value`: Output<FlowDefinitionHumanLoopConfigPublicWorkforceTaskPriceArgs>) {
        this.publicWorkforceTaskPrice = value
    }

    /**
     * @param value The length of time that a task remains available for review by human workers. Valid value range between `1` and `864000`.
     */
    @JvmName("lnslsnkpmgppnsyw")
    public suspend fun taskAvailabilityLifetimeInSeconds(`value`: Output<Int>) {
        this.taskAvailabilityLifetimeInSeconds = value
    }

    /**
     * @param value The number of distinct workers who will perform the same task on each object. Valid value range between `1` and `3`.
     */
    @JvmName("kjekvareqemsfsqn")
    public suspend fun taskCount(`value`: Output<Int>) {
        this.taskCount = value
    }

    /**
     * @param value A description for the human worker task.
     */
    @JvmName("iosmqavehcmoktgc")
    public suspend fun taskDescription(`value`: Output<String>) {
        this.taskDescription = value
    }

    /**
     * @param value An array of keywords used to describe the task so that workers can discover the task.
     */
    @JvmName("lwobfqbcvydtjqkv")
    public suspend fun taskKeywords(`value`: Output<List<String>>) {
        this.taskKeywords = value
    }

    @JvmName("jrphligoakfiavlf")
    public suspend fun taskKeywords(vararg values: Output<String>) {
        this.taskKeywords = Output.all(values.asList())
    }

    /**
     * @param values An array of keywords used to describe the task so that workers can discover the task.
     */
    @JvmName("emnxqaugjiskxqgs")
    public suspend fun taskKeywords(values: List<Output<String>>) {
        this.taskKeywords = Output.all(values)
    }

    /**
     * @param value The amount of time that a worker has to complete a task. The default value is `3600` seconds.
     */
    @JvmName("vctmhobythhkewsh")
    public suspend fun taskTimeLimitInSeconds(`value`: Output<Int>) {
        this.taskTimeLimitInSeconds = value
    }

    /**
     * @param value A title for the human worker task.
     */
    @JvmName("jkrxpvugjrevyase")
    public suspend fun taskTitle(`value`: Output<String>) {
        this.taskTitle = value
    }

    /**
     * @param value The Amazon Resource Name (ARN) of the human task user interface. Amazon Resource Name (ARN) of a team of workers. For Public workforces see [AWS Docs](https://docs.aws.amazon.com/sagemaker/latest/dg/sms-workforce-management-public.html).
     */
    @JvmName("gannhyxftwnwdbje")
    public suspend fun workteamArn(`value`: Output<String>) {
        this.workteamArn = value
    }

    /**
     * @param value The Amazon Resource Name (ARN) of the human task user interface.
     */
    @JvmName("wtglhisvqucqvkcv")
    public suspend fun humanTaskUiArn(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.humanTaskUiArn = mapped
    }

    /**
     * @param value Defines the amount of money paid to an Amazon Mechanical Turk worker for each task performed. See Public Workforce Task Price details below.
     */
    @JvmName("fgugsumvfgwkqhcv")
    public suspend
    fun publicWorkforceTaskPrice(`value`: FlowDefinitionHumanLoopConfigPublicWorkforceTaskPriceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.publicWorkforceTaskPrice = mapped
    }

    /**
     * @param argument Defines the amount of money paid to an Amazon Mechanical Turk worker for each task performed. See Public Workforce Task Price details below.
     */
    @JvmName("ccrxrsojafdlgxjd")
    public suspend
    fun publicWorkforceTaskPrice(argument: suspend FlowDefinitionHumanLoopConfigPublicWorkforceTaskPriceArgsBuilder.() -> Unit) {
        val toBeMapped =
            FlowDefinitionHumanLoopConfigPublicWorkforceTaskPriceArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.publicWorkforceTaskPrice = mapped
    }

    /**
     * @param value The length of time that a task remains available for review by human workers. Valid value range between `1` and `864000`.
     */
    @JvmName("txieialgqnepxsgx")
    public suspend fun taskAvailabilityLifetimeInSeconds(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.taskAvailabilityLifetimeInSeconds = mapped
    }

    /**
     * @param value The number of distinct workers who will perform the same task on each object. Valid value range between `1` and `3`.
     */
    @JvmName("pdhqqjpxklwiuupe")
    public suspend fun taskCount(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.taskCount = mapped
    }

    /**
     * @param value A description for the human worker task.
     */
    @JvmName("aqucutkcfmkrkowd")
    public suspend fun taskDescription(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.taskDescription = mapped
    }

    /**
     * @param value An array of keywords used to describe the task so that workers can discover the task.
     */
    @JvmName("jodxdpnljotbksvo")
    public suspend fun taskKeywords(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.taskKeywords = mapped
    }

    /**
     * @param values An array of keywords used to describe the task so that workers can discover the task.
     */
    @JvmName("cqaocfkymrreqpfa")
    public suspend fun taskKeywords(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.taskKeywords = mapped
    }

    /**
     * @param value The amount of time that a worker has to complete a task. The default value is `3600` seconds.
     */
    @JvmName("gasuvpblwqtsbrjy")
    public suspend fun taskTimeLimitInSeconds(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.taskTimeLimitInSeconds = mapped
    }

    /**
     * @param value A title for the human worker task.
     */
    @JvmName("xwakpefombhmacgn")
    public suspend fun taskTitle(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.taskTitle = mapped
    }

    /**
     * @param value The Amazon Resource Name (ARN) of the human task user interface. Amazon Resource Name (ARN) of a team of workers. For Public workforces see [AWS Docs](https://docs.aws.amazon.com/sagemaker/latest/dg/sms-workforce-management-public.html).
     */
    @JvmName("ybnjjuohjokgqopm")
    public suspend fun workteamArn(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.workteamArn = mapped
    }

    internal fun build(): FlowDefinitionHumanLoopConfigArgs = FlowDefinitionHumanLoopConfigArgs(
        humanTaskUiArn = humanTaskUiArn ?: throw PulumiNullFieldException("humanTaskUiArn"),
        publicWorkforceTaskPrice = publicWorkforceTaskPrice,
        taskAvailabilityLifetimeInSeconds = taskAvailabilityLifetimeInSeconds,
        taskCount = taskCount ?: throw PulumiNullFieldException("taskCount"),
        taskDescription = taskDescription ?: throw PulumiNullFieldException("taskDescription"),
        taskKeywords = taskKeywords,
        taskTimeLimitInSeconds = taskTimeLimitInSeconds,
        taskTitle = taskTitle ?: throw PulumiNullFieldException("taskTitle"),
        workteamArn = workteamArn ?: throw PulumiNullFieldException("workteamArn"),
    )
}
