@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sagemaker.kotlin.inputs

import com.pulumi.aws.sagemaker.inputs.FlowDefinitionHumanLoopConfigPublicWorkforceTaskPriceArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property amountInUsd Defines the amount of money paid to an Amazon Mechanical Turk worker in United States dollars. See Amount In Usd details below.
 */
public data class FlowDefinitionHumanLoopConfigPublicWorkforceTaskPriceArgs(
    public val amountInUsd:
    Output<FlowDefinitionHumanLoopConfigPublicWorkforceTaskPriceAmountInUsdArgs>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.sagemaker.inputs.FlowDefinitionHumanLoopConfigPublicWorkforceTaskPriceArgs> {
    override fun toJava():
        com.pulumi.aws.sagemaker.inputs.FlowDefinitionHumanLoopConfigPublicWorkforceTaskPriceArgs =
        com.pulumi.aws.sagemaker.inputs.FlowDefinitionHumanLoopConfigPublicWorkforceTaskPriceArgs.builder()
            .amountInUsd(amountInUsd?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [FlowDefinitionHumanLoopConfigPublicWorkforceTaskPriceArgs].
 */
@PulumiTagMarker
public class FlowDefinitionHumanLoopConfigPublicWorkforceTaskPriceArgsBuilder internal constructor() {
    private var amountInUsd:
        Output<FlowDefinitionHumanLoopConfigPublicWorkforceTaskPriceAmountInUsdArgs>? = null

    /**
     * @param value Defines the amount of money paid to an Amazon Mechanical Turk worker in United States dollars. See Amount In Usd details below.
     */
    @JvmName("dwthhleqqfcxeuav")
    public suspend
    fun amountInUsd(`value`: Output<FlowDefinitionHumanLoopConfigPublicWorkforceTaskPriceAmountInUsdArgs>) {
        this.amountInUsd = value
    }

    /**
     * @param value Defines the amount of money paid to an Amazon Mechanical Turk worker in United States dollars. See Amount In Usd details below.
     */
    @JvmName("hqannjxslmimngjf")
    public suspend
    fun amountInUsd(`value`: FlowDefinitionHumanLoopConfigPublicWorkforceTaskPriceAmountInUsdArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.amountInUsd = mapped
    }

    /**
     * @param argument Defines the amount of money paid to an Amazon Mechanical Turk worker in United States dollars. See Amount In Usd details below.
     */
    @JvmName("ooyekupkwxmcefqf")
    public suspend
    fun amountInUsd(argument: suspend FlowDefinitionHumanLoopConfigPublicWorkforceTaskPriceAmountInUsdArgsBuilder.() -> Unit) {
        val toBeMapped =
            FlowDefinitionHumanLoopConfigPublicWorkforceTaskPriceAmountInUsdArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.amountInUsd = mapped
    }

    internal fun build(): FlowDefinitionHumanLoopConfigPublicWorkforceTaskPriceArgs =
        FlowDefinitionHumanLoopConfigPublicWorkforceTaskPriceArgs(
            amountInUsd = amountInUsd,
        )
}
