@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sagemaker.kotlin.inputs

import com.pulumi.aws.sagemaker.inputs.FlowDefinitionOutputConfigArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property kmsKeyId The Amazon Key Management Service (KMS) key ARN for server-side encryption.
 * @property s3OutputPath The Amazon S3 path where the object containing human output will be made available.
 */
public data class FlowDefinitionOutputConfigArgs(
    public val kmsKeyId: Output<String>? = null,
    public val s3OutputPath: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.sagemaker.inputs.FlowDefinitionOutputConfigArgs> {
    override fun toJava(): com.pulumi.aws.sagemaker.inputs.FlowDefinitionOutputConfigArgs =
        com.pulumi.aws.sagemaker.inputs.FlowDefinitionOutputConfigArgs.builder()
            .kmsKeyId(kmsKeyId?.applyValue({ args0 -> args0 }))
            .s3OutputPath(s3OutputPath.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [FlowDefinitionOutputConfigArgs].
 */
@PulumiTagMarker
public class FlowDefinitionOutputConfigArgsBuilder internal constructor() {
    private var kmsKeyId: Output<String>? = null

    private var s3OutputPath: Output<String>? = null

    /**
     * @param value The Amazon Key Management Service (KMS) key ARN for server-side encryption.
     */
    @JvmName("vfwjiekblcbrvrbg")
    public suspend fun kmsKeyId(`value`: Output<String>) {
        this.kmsKeyId = value
    }

    /**
     * @param value The Amazon S3 path where the object containing human output will be made available.
     */
    @JvmName("axhuywmnqpultxdb")
    public suspend fun s3OutputPath(`value`: Output<String>) {
        this.s3OutputPath = value
    }

    /**
     * @param value The Amazon Key Management Service (KMS) key ARN for server-side encryption.
     */
    @JvmName("vaogejrabglnlkfx")
    public suspend fun kmsKeyId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kmsKeyId = mapped
    }

    /**
     * @param value The Amazon S3 path where the object containing human output will be made available.
     */
    @JvmName("joijdiqxjysypejf")
    public suspend fun s3OutputPath(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.s3OutputPath = mapped
    }

    internal fun build(): FlowDefinitionOutputConfigArgs = FlowDefinitionOutputConfigArgs(
        kmsKeyId = kmsKeyId,
        s3OutputPath = s3OutputPath ?: throw PulumiNullFieldException("s3OutputPath"),
    )
}
