@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sagemaker.kotlin.inputs

import com.pulumi.aws.sagemaker.inputs.GetPrebuiltEcrImagePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getPrebuiltEcrImage.
 * @property dnsSuffix DNS suffix to use in the registry path. If not specified, the AWS provider sets it to the DNS suffix for the current region.
 * @property imageTag Image tag for the Docker image. If not specified, the AWS provider sets the value to `1`, which for many repositories indicates the latest version. Some repositories, such as XGBoost, do not support `1` or `latest` and specific version must be used.
 * @property region Region to use in the registry path. If not specified, the AWS provider sets it to the current region.
 * @property repositoryName Name of the repository, which is generally the algorithm or library. Values include `blazingtext`, `factorization-machines`, `forecasting-deepar`, `image-classification`, `ipinsights`, `kmeans`, `knn`, `lda`, `linear-learner`, `mxnet-inference-eia`, `mxnet-inference`, `mxnet-training`, `ntm`, `object-detection`, `object2vec`, `pca`, `pytorch-inference-eia`, `pytorch-inference`, `pytorch-training`, `randomcutforest`, `sagemaker-scikit-learn`, `sagemaker-sparkml-serving`, `sagemaker-xgboost`, `semantic-segmentation`, `seq2seq`, `tensorflow-inference-eia`, `tensorflow-inference`, `tensorflow-training`, `huggingface-tensorflow-training`, `huggingface-tensorflow-inference`, `huggingface-pytorch-training`, and `huggingface-pytorch-inference`.
 */
public data class GetPrebuiltEcrImagePlainArgs(
    public val dnsSuffix: String? = null,
    public val imageTag: String? = null,
    public val region: String? = null,
    public val repositoryName: String,
) : ConvertibleToJava<com.pulumi.aws.sagemaker.inputs.GetPrebuiltEcrImagePlainArgs> {
    override fun toJava(): com.pulumi.aws.sagemaker.inputs.GetPrebuiltEcrImagePlainArgs =
        com.pulumi.aws.sagemaker.inputs.GetPrebuiltEcrImagePlainArgs.builder()
            .dnsSuffix(dnsSuffix?.let({ args0 -> args0 }))
            .imageTag(imageTag?.let({ args0 -> args0 }))
            .region(region?.let({ args0 -> args0 }))
            .repositoryName(repositoryName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetPrebuiltEcrImagePlainArgs].
 */
@PulumiTagMarker
public class GetPrebuiltEcrImagePlainArgsBuilder internal constructor() {
    private var dnsSuffix: String? = null

    private var imageTag: String? = null

    private var region: String? = null

    private var repositoryName: String? = null

    /**
     * @param value DNS suffix to use in the registry path. If not specified, the AWS provider sets it to the DNS suffix for the current region.
     */
    @JvmName("utbytkhdgcivbuoe")
    public suspend fun dnsSuffix(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.dnsSuffix = mapped
    }

    /**
     * @param value Image tag for the Docker image. If not specified, the AWS provider sets the value to `1`, which for many repositories indicates the latest version. Some repositories, such as XGBoost, do not support `1` or `latest` and specific version must be used.
     */
    @JvmName("vjguhfamrxjeqops")
    public suspend fun imageTag(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.imageTag = mapped
    }

    /**
     * @param value Region to use in the registry path. If not specified, the AWS provider sets it to the current region.
     */
    @JvmName("ichtikkjivgbnkpg")
    public suspend fun region(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.region = mapped
    }

    /**
     * @param value Name of the repository, which is generally the algorithm or library. Values include `blazingtext`, `factorization-machines`, `forecasting-deepar`, `image-classification`, `ipinsights`, `kmeans`, `knn`, `lda`, `linear-learner`, `mxnet-inference-eia`, `mxnet-inference`, `mxnet-training`, `ntm`, `object-detection`, `object2vec`, `pca`, `pytorch-inference-eia`, `pytorch-inference`, `pytorch-training`, `randomcutforest`, `sagemaker-scikit-learn`, `sagemaker-sparkml-serving`, `sagemaker-xgboost`, `semantic-segmentation`, `seq2seq`, `tensorflow-inference-eia`, `tensorflow-inference`, `tensorflow-training`, `huggingface-tensorflow-training`, `huggingface-tensorflow-inference`, `huggingface-pytorch-training`, and `huggingface-pytorch-inference`.
     */
    @JvmName("qeaqcceoiereygkr")
    public suspend fun repositoryName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.repositoryName = mapped
    }

    internal fun build(): GetPrebuiltEcrImagePlainArgs = GetPrebuiltEcrImagePlainArgs(
        dnsSuffix = dnsSuffix,
        imageTag = imageTag,
        region = region,
        repositoryName = repositoryName ?: throw PulumiNullFieldException("repositoryName"),
    )
}
