@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sagemaker.kotlin.inputs

import com.pulumi.aws.sagemaker.inputs.ModelPrimaryContainerArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 *
 * @property containerHostname The DNS host name for the container.
 * @property environment Environment variables for the Docker container.
 * A list of key value pairs.
 * @property image The registry path where the inference code image is stored in Amazon ECR.
 * @property imageConfig Specifies whether the model container is in Amazon ECR or a private Docker registry accessible from your Amazon Virtual Private Cloud (VPC). For more information see [Using a Private Docker Registry for Real-Time Inference Containers](https://docs.aws.amazon.com/sagemaker/latest/dg/your-algorithms-containers-inference-private.html). see Image Config.
 * @property mode The container hosts value `SingleModel/MultiModel`. The default value is `SingleModel`.
 * @property modelDataSource The location of model data to deploy. Use this for uncompressed model deployment. For information about how to deploy an uncompressed model, see [Deploying uncompressed models](https://docs.aws.amazon.com/sagemaker/latest/dg/large-model-inference-uncompressed.html) in the _AWS SageMaker Developer Guide_.
 * @property modelDataUrl The URL for the S3 location where model artifacts are stored.
 * @property modelPackageName The Amazon Resource Name (ARN) of the model package to use to create the model.
 */
public data class ModelPrimaryContainerArgs(
    public val containerHostname: Output<String>? = null,
    public val environment: Output<Map<String, String>>? = null,
    public val image: Output<String>? = null,
    public val imageConfig: Output<ModelPrimaryContainerImageConfigArgs>? = null,
    public val mode: Output<String>? = null,
    public val modelDataSource: Output<ModelPrimaryContainerModelDataSourceArgs>? = null,
    public val modelDataUrl: Output<String>? = null,
    public val modelPackageName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.sagemaker.inputs.ModelPrimaryContainerArgs> {
    override fun toJava(): com.pulumi.aws.sagemaker.inputs.ModelPrimaryContainerArgs =
        com.pulumi.aws.sagemaker.inputs.ModelPrimaryContainerArgs.builder()
            .containerHostname(containerHostname?.applyValue({ args0 -> args0 }))
            .environment(
                environment?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            )
            .image(image?.applyValue({ args0 -> args0 }))
            .imageConfig(imageConfig?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .mode(mode?.applyValue({ args0 -> args0 }))
            .modelDataSource(modelDataSource?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .modelDataUrl(modelDataUrl?.applyValue({ args0 -> args0 }))
            .modelPackageName(modelPackageName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ModelPrimaryContainerArgs].
 */
@PulumiTagMarker
public class ModelPrimaryContainerArgsBuilder internal constructor() {
    private var containerHostname: Output<String>? = null

    private var environment: Output<Map<String, String>>? = null

    private var image: Output<String>? = null

    private var imageConfig: Output<ModelPrimaryContainerImageConfigArgs>? = null

    private var mode: Output<String>? = null

    private var modelDataSource: Output<ModelPrimaryContainerModelDataSourceArgs>? = null

    private var modelDataUrl: Output<String>? = null

    private var modelPackageName: Output<String>? = null

    /**
     * @param value The DNS host name for the container.
     */
    @JvmName("wabxvlqtwgvrfhui")
    public suspend fun containerHostname(`value`: Output<String>) {
        this.containerHostname = value
    }

    /**
     * @param value Environment variables for the Docker container.
     * A list of key value pairs.
     */
    @JvmName("rajahnjtaydcmufs")
    public suspend fun environment(`value`: Output<Map<String, String>>) {
        this.environment = value
    }

    /**
     * @param value The registry path where the inference code image is stored in Amazon ECR.
     */
    @JvmName("okbmlpkbdvpufuyn")
    public suspend fun image(`value`: Output<String>) {
        this.image = value
    }

    /**
     * @param value Specifies whether the model container is in Amazon ECR or a private Docker registry accessible from your Amazon Virtual Private Cloud (VPC). For more information see [Using a Private Docker Registry for Real-Time Inference Containers](https://docs.aws.amazon.com/sagemaker/latest/dg/your-algorithms-containers-inference-private.html). see Image Config.
     */
    @JvmName("rwswoendyniejsut")
    public suspend fun imageConfig(`value`: Output<ModelPrimaryContainerImageConfigArgs>) {
        this.imageConfig = value
    }

    /**
     * @param value The container hosts value `SingleModel/MultiModel`. The default value is `SingleModel`.
     */
    @JvmName("ywoohqgqydpmwlcq")
    public suspend fun mode(`value`: Output<String>) {
        this.mode = value
    }

    /**
     * @param value The location of model data to deploy. Use this for uncompressed model deployment. For information about how to deploy an uncompressed model, see [Deploying uncompressed models](https://docs.aws.amazon.com/sagemaker/latest/dg/large-model-inference-uncompressed.html) in the _AWS SageMaker Developer Guide_.
     */
    @JvmName("dpvoqwrhqluedncl")
    public suspend fun modelDataSource(`value`: Output<ModelPrimaryContainerModelDataSourceArgs>) {
        this.modelDataSource = value
    }

    /**
     * @param value The URL for the S3 location where model artifacts are stored.
     */
    @JvmName("bgpfvvqmdanncyyx")
    public suspend fun modelDataUrl(`value`: Output<String>) {
        this.modelDataUrl = value
    }

    /**
     * @param value The Amazon Resource Name (ARN) of the model package to use to create the model.
     */
    @JvmName("iogoviqoxlipxvgx")
    public suspend fun modelPackageName(`value`: Output<String>) {
        this.modelPackageName = value
    }

    /**
     * @param value The DNS host name for the container.
     */
    @JvmName("oxdbadjqgheasvkf")
    public suspend fun containerHostname(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.containerHostname = mapped
    }

    /**
     * @param value Environment variables for the Docker container.
     * A list of key value pairs.
     */
    @JvmName("sppsclvaoewwekln")
    public suspend fun environment(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.environment = mapped
    }

    /**
     * @param values Environment variables for the Docker container.
     * A list of key value pairs.
     */
    @JvmName("lcwfpmrrpoytgqja")
    public fun environment(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.environment = mapped
    }

    /**
     * @param value The registry path where the inference code image is stored in Amazon ECR.
     */
    @JvmName("wgavrdhwywblfphj")
    public suspend fun image(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.image = mapped
    }

    /**
     * @param value Specifies whether the model container is in Amazon ECR or a private Docker registry accessible from your Amazon Virtual Private Cloud (VPC). For more information see [Using a Private Docker Registry for Real-Time Inference Containers](https://docs.aws.amazon.com/sagemaker/latest/dg/your-algorithms-containers-inference-private.html). see Image Config.
     */
    @JvmName("ganthavixyjmktij")
    public suspend fun imageConfig(`value`: ModelPrimaryContainerImageConfigArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.imageConfig = mapped
    }

    /**
     * @param argument Specifies whether the model container is in Amazon ECR or a private Docker registry accessible from your Amazon Virtual Private Cloud (VPC). For more information see [Using a Private Docker Registry for Real-Time Inference Containers](https://docs.aws.amazon.com/sagemaker/latest/dg/your-algorithms-containers-inference-private.html). see Image Config.
     */
    @JvmName("hokythauxanxkdcg")
    public suspend
    fun imageConfig(argument: suspend ModelPrimaryContainerImageConfigArgsBuilder.() -> Unit) {
        val toBeMapped = ModelPrimaryContainerImageConfigArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.imageConfig = mapped
    }

    /**
     * @param value The container hosts value `SingleModel/MultiModel`. The default value is `SingleModel`.
     */
    @JvmName("tmiiqjktdhpaooir")
    public suspend fun mode(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.mode = mapped
    }

    /**
     * @param value The location of model data to deploy. Use this for uncompressed model deployment. For information about how to deploy an uncompressed model, see [Deploying uncompressed models](https://docs.aws.amazon.com/sagemaker/latest/dg/large-model-inference-uncompressed.html) in the _AWS SageMaker Developer Guide_.
     */
    @JvmName("rlfjuqufcbjakrlw")
    public suspend fun modelDataSource(`value`: ModelPrimaryContainerModelDataSourceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.modelDataSource = mapped
    }

    /**
     * @param argument The location of model data to deploy. Use this for uncompressed model deployment. For information about how to deploy an uncompressed model, see [Deploying uncompressed models](https://docs.aws.amazon.com/sagemaker/latest/dg/large-model-inference-uncompressed.html) in the _AWS SageMaker Developer Guide_.
     */
    @JvmName("esbfwufwiwtiotrq")
    public suspend
    fun modelDataSource(argument: suspend ModelPrimaryContainerModelDataSourceArgsBuilder.() -> Unit) {
        val toBeMapped = ModelPrimaryContainerModelDataSourceArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.modelDataSource = mapped
    }

    /**
     * @param value The URL for the S3 location where model artifacts are stored.
     */
    @JvmName("eutjchuxcbnbmohy")
    public suspend fun modelDataUrl(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.modelDataUrl = mapped
    }

    /**
     * @param value The Amazon Resource Name (ARN) of the model package to use to create the model.
     */
    @JvmName("iwcifmglsfqsyvdc")
    public suspend fun modelPackageName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.modelPackageName = mapped
    }

    internal fun build(): ModelPrimaryContainerArgs = ModelPrimaryContainerArgs(
        containerHostname = containerHostname,
        environment = environment,
        image = image,
        imageConfig = imageConfig,
        mode = mode,
        modelDataSource = modelDataSource,
        modelDataUrl = modelDataUrl,
        modelPackageName = modelPackageName,
    )
}
