@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sagemaker.kotlin.inputs

import com.pulumi.aws.sagemaker.inputs.ModelPrimaryContainerModelDataSourceS3DataSourceArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property compressionType How the model data is prepared. Allowed values are: `None` and `Gzip`.
 * @property s3DataType The type of model data to deploy. Allowed values are: `S3Object` and `S3Prefix`.
 * @property s3Uri The S3 path of model data to deploy.
 */
public data class ModelPrimaryContainerModelDataSourceS3DataSourceArgs(
    public val compressionType: Output<String>,
    public val s3DataType: Output<String>,
    public val s3Uri: Output<String>,
) :
    ConvertibleToJava<com.pulumi.aws.sagemaker.inputs.ModelPrimaryContainerModelDataSourceS3DataSourceArgs> {
    override fun toJava():
        com.pulumi.aws.sagemaker.inputs.ModelPrimaryContainerModelDataSourceS3DataSourceArgs =
        com.pulumi.aws.sagemaker.inputs.ModelPrimaryContainerModelDataSourceS3DataSourceArgs.builder()
            .compressionType(compressionType.applyValue({ args0 -> args0 }))
            .s3DataType(s3DataType.applyValue({ args0 -> args0 }))
            .s3Uri(s3Uri.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ModelPrimaryContainerModelDataSourceS3DataSourceArgs].
 */
@PulumiTagMarker
public class ModelPrimaryContainerModelDataSourceS3DataSourceArgsBuilder internal constructor() {
    private var compressionType: Output<String>? = null

    private var s3DataType: Output<String>? = null

    private var s3Uri: Output<String>? = null

    /**
     * @param value How the model data is prepared. Allowed values are: `None` and `Gzip`.
     */
    @JvmName("oqcbwwdxhpnemcwu")
    public suspend fun compressionType(`value`: Output<String>) {
        this.compressionType = value
    }

    /**
     * @param value The type of model data to deploy. Allowed values are: `S3Object` and `S3Prefix`.
     */
    @JvmName("gpgetctkueiyvkcl")
    public suspend fun s3DataType(`value`: Output<String>) {
        this.s3DataType = value
    }

    /**
     * @param value The S3 path of model data to deploy.
     */
    @JvmName("wnibelhkbilkmanq")
    public suspend fun s3Uri(`value`: Output<String>) {
        this.s3Uri = value
    }

    /**
     * @param value How the model data is prepared. Allowed values are: `None` and `Gzip`.
     */
    @JvmName("rbgxcaysmtikixye")
    public suspend fun compressionType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.compressionType = mapped
    }

    /**
     * @param value The type of model data to deploy. Allowed values are: `S3Object` and `S3Prefix`.
     */
    @JvmName("luolwtjrpspxryvc")
    public suspend fun s3DataType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.s3DataType = mapped
    }

    /**
     * @param value The S3 path of model data to deploy.
     */
    @JvmName("tgtwcrwldisvretv")
    public suspend fun s3Uri(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.s3Uri = mapped
    }

    internal fun build(): ModelPrimaryContainerModelDataSourceS3DataSourceArgs =
        ModelPrimaryContainerModelDataSourceS3DataSourceArgs(
            compressionType = compressionType ?: throw PulumiNullFieldException("compressionType"),
            s3DataType = s3DataType ?: throw PulumiNullFieldException("s3DataType"),
            s3Uri = s3Uri ?: throw PulumiNullFieldException("s3Uri"),
        )
}
