@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sagemaker.kotlin.inputs

import com.pulumi.aws.sagemaker.inputs.MonitoringScheduleMonitoringScheduleConfigArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property monitoringJobDefinitionName The name of the monitoring job definition to schedule.
 * @property monitoringType The type of the monitoring job definition to schedule. Valid values are `DataQuality`, `ModelQuality`, `ModelBias` or `ModelExplainability`
 * @property scheduleConfig Configures the monitoring schedule. Fields are documented below.
 */
public data class MonitoringScheduleMonitoringScheduleConfigArgs(
    public val monitoringJobDefinitionName: Output<String>,
    public val monitoringType: Output<String>,
    public val scheduleConfig: Output<MonitoringScheduleMonitoringScheduleConfigScheduleConfigArgs>? =
        null,
) :
    ConvertibleToJava<com.pulumi.aws.sagemaker.inputs.MonitoringScheduleMonitoringScheduleConfigArgs> {
    override fun toJava():
        com.pulumi.aws.sagemaker.inputs.MonitoringScheduleMonitoringScheduleConfigArgs =
        com.pulumi.aws.sagemaker.inputs.MonitoringScheduleMonitoringScheduleConfigArgs.builder()
            .monitoringJobDefinitionName(monitoringJobDefinitionName.applyValue({ args0 -> args0 }))
            .monitoringType(monitoringType.applyValue({ args0 -> args0 }))
            .scheduleConfig(
                scheduleConfig?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [MonitoringScheduleMonitoringScheduleConfigArgs].
 */
@PulumiTagMarker
public class MonitoringScheduleMonitoringScheduleConfigArgsBuilder internal constructor() {
    private var monitoringJobDefinitionName: Output<String>? = null

    private var monitoringType: Output<String>? = null

    private var scheduleConfig: Output<MonitoringScheduleMonitoringScheduleConfigScheduleConfigArgs>? =
        null

    /**
     * @param value The name of the monitoring job definition to schedule.
     */
    @JvmName("rjftxktauspydmct")
    public suspend fun monitoringJobDefinitionName(`value`: Output<String>) {
        this.monitoringJobDefinitionName = value
    }

    /**
     * @param value The type of the monitoring job definition to schedule. Valid values are `DataQuality`, `ModelQuality`, `ModelBias` or `ModelExplainability`
     */
    @JvmName("scybfarxpvmnyppi")
    public suspend fun monitoringType(`value`: Output<String>) {
        this.monitoringType = value
    }

    /**
     * @param value Configures the monitoring schedule. Fields are documented below.
     */
    @JvmName("vuneupyfgsyhfjvl")
    public suspend
    fun scheduleConfig(`value`: Output<MonitoringScheduleMonitoringScheduleConfigScheduleConfigArgs>) {
        this.scheduleConfig = value
    }

    /**
     * @param value The name of the monitoring job definition to schedule.
     */
    @JvmName("ftavhtswivqiwmet")
    public suspend fun monitoringJobDefinitionName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.monitoringJobDefinitionName = mapped
    }

    /**
     * @param value The type of the monitoring job definition to schedule. Valid values are `DataQuality`, `ModelQuality`, `ModelBias` or `ModelExplainability`
     */
    @JvmName("awxnxanpefylngnl")
    public suspend fun monitoringType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.monitoringType = mapped
    }

    /**
     * @param value Configures the monitoring schedule. Fields are documented below.
     */
    @JvmName("dcvrsewgocshaywx")
    public suspend
    fun scheduleConfig(`value`: MonitoringScheduleMonitoringScheduleConfigScheduleConfigArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.scheduleConfig = mapped
    }

    /**
     * @param argument Configures the monitoring schedule. Fields are documented below.
     */
    @JvmName("knvdrkgblhbmswdg")
    public suspend
    fun scheduleConfig(argument: suspend MonitoringScheduleMonitoringScheduleConfigScheduleConfigArgsBuilder.() -> Unit) {
        val toBeMapped =
            MonitoringScheduleMonitoringScheduleConfigScheduleConfigArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.scheduleConfig = mapped
    }

    internal fun build(): MonitoringScheduleMonitoringScheduleConfigArgs =
        MonitoringScheduleMonitoringScheduleConfigArgs(
            monitoringJobDefinitionName = monitoringJobDefinitionName ?: throw
                PulumiNullFieldException("monitoringJobDefinitionName"),
            monitoringType = monitoringType ?: throw PulumiNullFieldException("monitoringType"),
            scheduleConfig = scheduleConfig,
        )
}
