@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sagemaker.kotlin.inputs

import com.pulumi.aws.sagemaker.inputs.PipelineParallelismConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property maxParallelExecutionSteps The max number of steps that can be executed in parallel.
 */
public data class PipelineParallelismConfigurationArgs(
    public val maxParallelExecutionSteps: Output<Int>,
) : ConvertibleToJava<com.pulumi.aws.sagemaker.inputs.PipelineParallelismConfigurationArgs> {
    override fun toJava(): com.pulumi.aws.sagemaker.inputs.PipelineParallelismConfigurationArgs =
        com.pulumi.aws.sagemaker.inputs.PipelineParallelismConfigurationArgs.builder()
            .maxParallelExecutionSteps(maxParallelExecutionSteps.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [PipelineParallelismConfigurationArgs].
 */
@PulumiTagMarker
public class PipelineParallelismConfigurationArgsBuilder internal constructor() {
    private var maxParallelExecutionSteps: Output<Int>? = null

    /**
     * @param value The max number of steps that can be executed in parallel.
     */
    @JvmName("fsegikgwoqrfscyl")
    public suspend fun maxParallelExecutionSteps(`value`: Output<Int>) {
        this.maxParallelExecutionSteps = value
    }

    /**
     * @param value The max number of steps that can be executed in parallel.
     */
    @JvmName("bqfqnryhynebibtu")
    public suspend fun maxParallelExecutionSteps(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.maxParallelExecutionSteps = mapped
    }

    internal fun build(): PipelineParallelismConfigurationArgs = PipelineParallelismConfigurationArgs(
        maxParallelExecutionSteps = maxParallelExecutionSteps ?: throw
            PulumiNullFieldException("maxParallelExecutionSteps"),
    )
}
