@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sagemaker.kotlin.inputs

import com.pulumi.aws.sagemaker.inputs.PipelinePipelineDefinitionS3LocationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property bucket Name of the S3 bucket.
 * @property objectKey The object key (or key name) uniquely identifies the object in an S3 bucket.
 * @property versionId Version Id of the pipeline definition file. If not specified, Amazon SageMaker will retrieve the latest version.
 */
public data class PipelinePipelineDefinitionS3LocationArgs(
    public val bucket: Output<String>,
    public val objectKey: Output<String>,
    public val versionId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.sagemaker.inputs.PipelinePipelineDefinitionS3LocationArgs> {
    override fun toJava(): com.pulumi.aws.sagemaker.inputs.PipelinePipelineDefinitionS3LocationArgs =
        com.pulumi.aws.sagemaker.inputs.PipelinePipelineDefinitionS3LocationArgs.builder()
            .bucket(bucket.applyValue({ args0 -> args0 }))
            .objectKey(objectKey.applyValue({ args0 -> args0 }))
            .versionId(versionId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [PipelinePipelineDefinitionS3LocationArgs].
 */
@PulumiTagMarker
public class PipelinePipelineDefinitionS3LocationArgsBuilder internal constructor() {
    private var bucket: Output<String>? = null

    private var objectKey: Output<String>? = null

    private var versionId: Output<String>? = null

    /**
     * @param value Name of the S3 bucket.
     */
    @JvmName("tjxvksguuaefghjh")
    public suspend fun bucket(`value`: Output<String>) {
        this.bucket = value
    }

    /**
     * @param value The object key (or key name) uniquely identifies the object in an S3 bucket.
     */
    @JvmName("fohauejbidpjsrga")
    public suspend fun objectKey(`value`: Output<String>) {
        this.objectKey = value
    }

    /**
     * @param value Version Id of the pipeline definition file. If not specified, Amazon SageMaker will retrieve the latest version.
     */
    @JvmName("kfduldgfqsebgipm")
    public suspend fun versionId(`value`: Output<String>) {
        this.versionId = value
    }

    /**
     * @param value Name of the S3 bucket.
     */
    @JvmName("baxcjtncrjhairve")
    public suspend fun bucket(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.bucket = mapped
    }

    /**
     * @param value The object key (or key name) uniquely identifies the object in an S3 bucket.
     */
    @JvmName("ywtpvngbylseqfqp")
    public suspend fun objectKey(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.objectKey = mapped
    }

    /**
     * @param value Version Id of the pipeline definition file. If not specified, Amazon SageMaker will retrieve the latest version.
     */
    @JvmName("uyyspjxlehwpihwa")
    public suspend fun versionId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.versionId = mapped
    }

    internal fun build(): PipelinePipelineDefinitionS3LocationArgs =
        PipelinePipelineDefinitionS3LocationArgs(
            bucket = bucket ?: throw PulumiNullFieldException("bucket"),
            objectKey = objectKey ?: throw PulumiNullFieldException("objectKey"),
            versionId = versionId,
        )
}
