@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sagemaker.kotlin.inputs

import com.pulumi.aws.sagemaker.inputs.SpaceSpaceSettingsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property jupyterServerAppSettings The Jupyter server's app settings. See Jupyter Server App Settings below.
 * @property kernelGatewayAppSettings The kernel gateway app settings. See Kernel Gateway App Settings below.
 */
public data class SpaceSpaceSettingsArgs(
    public val jupyterServerAppSettings: Output<SpaceSpaceSettingsJupyterServerAppSettingsArgs>? =
        null,
    public val kernelGatewayAppSettings: Output<SpaceSpaceSettingsKernelGatewayAppSettingsArgs>? =
        null,
) : ConvertibleToJava<com.pulumi.aws.sagemaker.inputs.SpaceSpaceSettingsArgs> {
    override fun toJava(): com.pulumi.aws.sagemaker.inputs.SpaceSpaceSettingsArgs =
        com.pulumi.aws.sagemaker.inputs.SpaceSpaceSettingsArgs.builder()
            .jupyterServerAppSettings(
                jupyterServerAppSettings?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .kernelGatewayAppSettings(
                kernelGatewayAppSettings?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [SpaceSpaceSettingsArgs].
 */
@PulumiTagMarker
public class SpaceSpaceSettingsArgsBuilder internal constructor() {
    private var jupyterServerAppSettings: Output<SpaceSpaceSettingsJupyterServerAppSettingsArgs>? =
        null

    private var kernelGatewayAppSettings: Output<SpaceSpaceSettingsKernelGatewayAppSettingsArgs>? =
        null

    /**
     * @param value The Jupyter server's app settings. See Jupyter Server App Settings below.
     */
    @JvmName("mriwvdsxrqwmytes")
    public suspend
    fun jupyterServerAppSettings(`value`: Output<SpaceSpaceSettingsJupyterServerAppSettingsArgs>) {
        this.jupyterServerAppSettings = value
    }

    /**
     * @param value The kernel gateway app settings. See Kernel Gateway App Settings below.
     */
    @JvmName("uavuoxwlufvlkaku")
    public suspend
    fun kernelGatewayAppSettings(`value`: Output<SpaceSpaceSettingsKernelGatewayAppSettingsArgs>) {
        this.kernelGatewayAppSettings = value
    }

    /**
     * @param value The Jupyter server's app settings. See Jupyter Server App Settings below.
     */
    @JvmName("chvavwbtppdsqohy")
    public suspend
    fun jupyterServerAppSettings(`value`: SpaceSpaceSettingsJupyterServerAppSettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.jupyterServerAppSettings = mapped
    }

    /**
     * @param argument The Jupyter server's app settings. See Jupyter Server App Settings below.
     */
    @JvmName("qpnngklsavxtvqqj")
    public suspend
    fun jupyterServerAppSettings(argument: suspend SpaceSpaceSettingsJupyterServerAppSettingsArgsBuilder.() -> Unit) {
        val toBeMapped = SpaceSpaceSettingsJupyterServerAppSettingsArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.jupyterServerAppSettings = mapped
    }

    /**
     * @param value The kernel gateway app settings. See Kernel Gateway App Settings below.
     */
    @JvmName("umlsgaesrunganbi")
    public suspend
    fun kernelGatewayAppSettings(`value`: SpaceSpaceSettingsKernelGatewayAppSettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kernelGatewayAppSettings = mapped
    }

    /**
     * @param argument The kernel gateway app settings. See Kernel Gateway App Settings below.
     */
    @JvmName("bbglmnqmuqigvgml")
    public suspend
    fun kernelGatewayAppSettings(argument: suspend SpaceSpaceSettingsKernelGatewayAppSettingsArgsBuilder.() -> Unit) {
        val toBeMapped = SpaceSpaceSettingsKernelGatewayAppSettingsArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.kernelGatewayAppSettings = mapped
    }

    internal fun build(): SpaceSpaceSettingsArgs = SpaceSpaceSettingsArgs(
        jupyterServerAppSettings = jupyterServerAppSettings,
        kernelGatewayAppSettings = kernelGatewayAppSettings,
    )
}
