@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sagemaker.kotlin.inputs

import com.pulumi.aws.sagemaker.inputs.SpaceSpaceSettingsKernelGatewayAppSettingsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property customImages A list of custom SageMaker images that are configured to run as a KernelGateway app. see Custom Image below.
 * @property defaultResourceSpec The default instance type and the Amazon Resource Name (ARN) of the SageMaker image created on the instance. see Default Resource Spec below.
 * @property lifecycleConfigArns The Amazon Resource Name (ARN) of the Lifecycle Configurations.
 */
public data class SpaceSpaceSettingsKernelGatewayAppSettingsArgs(
    public val customImages: Output<List<SpaceSpaceSettingsKernelGatewayAppSettingsCustomImageArgs>>? =
        null,
    public val defaultResourceSpec:
    Output<SpaceSpaceSettingsKernelGatewayAppSettingsDefaultResourceSpecArgs>,
    public val lifecycleConfigArns: Output<List<String>>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.sagemaker.inputs.SpaceSpaceSettingsKernelGatewayAppSettingsArgs> {
    override fun toJava():
        com.pulumi.aws.sagemaker.inputs.SpaceSpaceSettingsKernelGatewayAppSettingsArgs =
        com.pulumi.aws.sagemaker.inputs.SpaceSpaceSettingsKernelGatewayAppSettingsArgs.builder()
            .customImages(
                customImages?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .defaultResourceSpec(
                defaultResourceSpec.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .lifecycleConfigArns(
                lifecycleConfigArns?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0
                    })
                }),
            ).build()
}

/**
 * Builder for [SpaceSpaceSettingsKernelGatewayAppSettingsArgs].
 */
@PulumiTagMarker
public class SpaceSpaceSettingsKernelGatewayAppSettingsArgsBuilder internal constructor() {
    private var customImages: Output<List<SpaceSpaceSettingsKernelGatewayAppSettingsCustomImageArgs>>? =
        null

    private var defaultResourceSpec:
        Output<SpaceSpaceSettingsKernelGatewayAppSettingsDefaultResourceSpecArgs>? = null

    private var lifecycleConfigArns: Output<List<String>>? = null

    /**
     * @param value A list of custom SageMaker images that are configured to run as a KernelGateway app. see Custom Image below.
     */
    @JvmName("gofluheqlppieskn")
    public suspend
    fun customImages(`value`: Output<List<SpaceSpaceSettingsKernelGatewayAppSettingsCustomImageArgs>>) {
        this.customImages = value
    }

    @JvmName("ywnobblpaslcjktm")
    public suspend fun customImages(
        vararg
        values: Output<SpaceSpaceSettingsKernelGatewayAppSettingsCustomImageArgs>,
    ) {
        this.customImages = Output.all(values.asList())
    }

    /**
     * @param values A list of custom SageMaker images that are configured to run as a KernelGateway app. see Custom Image below.
     */
    @JvmName("tngavfuvaxkpkotd")
    public suspend
    fun customImages(values: List<Output<SpaceSpaceSettingsKernelGatewayAppSettingsCustomImageArgs>>) {
        this.customImages = Output.all(values)
    }

    /**
     * @param value The default instance type and the Amazon Resource Name (ARN) of the SageMaker image created on the instance. see Default Resource Spec below.
     */
    @JvmName("miyokebrgpfvasdu")
    public suspend
    fun defaultResourceSpec(`value`: Output<SpaceSpaceSettingsKernelGatewayAppSettingsDefaultResourceSpecArgs>) {
        this.defaultResourceSpec = value
    }

    /**
     * @param value The Amazon Resource Name (ARN) of the Lifecycle Configurations.
     */
    @JvmName("cbdfscclbgcfvbsj")
    public suspend fun lifecycleConfigArns(`value`: Output<List<String>>) {
        this.lifecycleConfigArns = value
    }

    @JvmName("etudeqoinmruyxhh")
    public suspend fun lifecycleConfigArns(vararg values: Output<String>) {
        this.lifecycleConfigArns = Output.all(values.asList())
    }

    /**
     * @param values The Amazon Resource Name (ARN) of the Lifecycle Configurations.
     */
    @JvmName("oxabpcpfsyglbysg")
    public suspend fun lifecycleConfigArns(values: List<Output<String>>) {
        this.lifecycleConfigArns = Output.all(values)
    }

    /**
     * @param value A list of custom SageMaker images that are configured to run as a KernelGateway app. see Custom Image below.
     */
    @JvmName("ohjwcblmmmgswbku")
    public suspend
    fun customImages(`value`: List<SpaceSpaceSettingsKernelGatewayAppSettingsCustomImageArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.customImages = mapped
    }

    /**
     * @param argument A list of custom SageMaker images that are configured to run as a KernelGateway app. see Custom Image below.
     */
    @JvmName("flykyhblsxtnkdrg")
    public suspend
    fun customImages(argument: List<suspend SpaceSpaceSettingsKernelGatewayAppSettingsCustomImageArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            SpaceSpaceSettingsKernelGatewayAppSettingsCustomImageArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.customImages = mapped
    }

    /**
     * @param argument A list of custom SageMaker images that are configured to run as a KernelGateway app. see Custom Image below.
     */
    @JvmName("homkenylhqgoyioi")
    public suspend fun customImages(
        vararg
        argument: suspend SpaceSpaceSettingsKernelGatewayAppSettingsCustomImageArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            SpaceSpaceSettingsKernelGatewayAppSettingsCustomImageArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.customImages = mapped
    }

    /**
     * @param argument A list of custom SageMaker images that are configured to run as a KernelGateway app. see Custom Image below.
     */
    @JvmName("rccwbnqhmlbjbenf")
    public suspend
    fun customImages(argument: suspend SpaceSpaceSettingsKernelGatewayAppSettingsCustomImageArgsBuilder.() -> Unit) {
        val toBeMapped =
            listOf(
                SpaceSpaceSettingsKernelGatewayAppSettingsCustomImageArgsBuilder().applySuspend {
                    argument()
                }.build(),
            )
        val mapped = of(toBeMapped)
        this.customImages = mapped
    }

    /**
     * @param values A list of custom SageMaker images that are configured to run as a KernelGateway app. see Custom Image below.
     */
    @JvmName("suiltgestvrwdmav")
    public suspend fun customImages(
        vararg
        values: SpaceSpaceSettingsKernelGatewayAppSettingsCustomImageArgs,
    ) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.customImages = mapped
    }

    /**
     * @param value The default instance type and the Amazon Resource Name (ARN) of the SageMaker image created on the instance. see Default Resource Spec below.
     */
    @JvmName("gbavgynlypowfnlv")
    public suspend
    fun defaultResourceSpec(`value`: SpaceSpaceSettingsKernelGatewayAppSettingsDefaultResourceSpecArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.defaultResourceSpec = mapped
    }

    /**
     * @param argument The default instance type and the Amazon Resource Name (ARN) of the SageMaker image created on the instance. see Default Resource Spec below.
     */
    @JvmName("tfaoknenjupdodlw")
    public suspend
    fun defaultResourceSpec(argument: suspend SpaceSpaceSettingsKernelGatewayAppSettingsDefaultResourceSpecArgsBuilder.() -> Unit) {
        val toBeMapped =
            SpaceSpaceSettingsKernelGatewayAppSettingsDefaultResourceSpecArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.defaultResourceSpec = mapped
    }

    /**
     * @param value The Amazon Resource Name (ARN) of the Lifecycle Configurations.
     */
    @JvmName("vdbbgnvboolivbie")
    public suspend fun lifecycleConfigArns(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.lifecycleConfigArns = mapped
    }

    /**
     * @param values The Amazon Resource Name (ARN) of the Lifecycle Configurations.
     */
    @JvmName("eqttiwpdwcyjnqvt")
    public suspend fun lifecycleConfigArns(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.lifecycleConfigArns = mapped
    }

    internal fun build(): SpaceSpaceSettingsKernelGatewayAppSettingsArgs =
        SpaceSpaceSettingsKernelGatewayAppSettingsArgs(
            customImages = customImages,
            defaultResourceSpec = defaultResourceSpec ?: throw PulumiNullFieldException("defaultResourceSpec"),
            lifecycleConfigArns = lifecycleConfigArns,
        )
}
