@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sagemaker.kotlin.inputs

import com.pulumi.aws.sagemaker.inputs.UserProfileUserSettingsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property canvasAppSettings The Canvas app settings. See Canvas App Settings below.
 * @property executionRole The execution role ARN for the user.
 * @property jupyterServerAppSettings The Jupyter server's app settings. See Jupyter Server App Settings below.
 * @property kernelGatewayAppSettings The kernel gateway app settings. See Kernel Gateway App Settings below.
 * @property rSessionAppSettings The RSession app settings. See RSession App Settings below.
 * @property rStudioServerProAppSettings A collection of settings that configure user interaction with the RStudioServerPro app. See RStudio Server Pro App Settings below.
 * @property securityGroups The security groups.
 * @property sharingSettings The sharing settings. See Sharing Settings below.
 * @property tensorBoardAppSettings The TensorBoard app settings. See TensorBoard App Settings below.
 */
public data class UserProfileUserSettingsArgs(
    public val canvasAppSettings: Output<UserProfileUserSettingsCanvasAppSettingsArgs>? = null,
    public val executionRole: Output<String>,
    public val jupyterServerAppSettings: Output<UserProfileUserSettingsJupyterServerAppSettingsArgs>? =
        null,
    public val kernelGatewayAppSettings: Output<UserProfileUserSettingsKernelGatewayAppSettingsArgs>? =
        null,
    public val rSessionAppSettings: Output<UserProfileUserSettingsRSessionAppSettingsArgs>? = null,
    public val rStudioServerProAppSettings:
    Output<UserProfileUserSettingsRStudioServerProAppSettingsArgs>? = null,
    public val securityGroups: Output<List<String>>? = null,
    public val sharingSettings: Output<UserProfileUserSettingsSharingSettingsArgs>? = null,
    public val tensorBoardAppSettings: Output<UserProfileUserSettingsTensorBoardAppSettingsArgs>? =
        null,
) : ConvertibleToJava<com.pulumi.aws.sagemaker.inputs.UserProfileUserSettingsArgs> {
    override fun toJava(): com.pulumi.aws.sagemaker.inputs.UserProfileUserSettingsArgs =
        com.pulumi.aws.sagemaker.inputs.UserProfileUserSettingsArgs.builder()
            .canvasAppSettings(canvasAppSettings?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .executionRole(executionRole.applyValue({ args0 -> args0 }))
            .jupyterServerAppSettings(
                jupyterServerAppSettings?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .kernelGatewayAppSettings(
                kernelGatewayAppSettings?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .rSessionAppSettings(
                rSessionAppSettings?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .rStudioServerProAppSettings(
                rStudioServerProAppSettings?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .securityGroups(securityGroups?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .sharingSettings(sharingSettings?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .tensorBoardAppSettings(
                tensorBoardAppSettings?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [UserProfileUserSettingsArgs].
 */
@PulumiTagMarker
public class UserProfileUserSettingsArgsBuilder internal constructor() {
    private var canvasAppSettings: Output<UserProfileUserSettingsCanvasAppSettingsArgs>? = null

    private var executionRole: Output<String>? = null

    private var jupyterServerAppSettings: Output<UserProfileUserSettingsJupyterServerAppSettingsArgs>? =
        null

    private var kernelGatewayAppSettings: Output<UserProfileUserSettingsKernelGatewayAppSettingsArgs>? =
        null

    private var rSessionAppSettings: Output<UserProfileUserSettingsRSessionAppSettingsArgs>? = null

    private var rStudioServerProAppSettings:
        Output<UserProfileUserSettingsRStudioServerProAppSettingsArgs>? = null

    private var securityGroups: Output<List<String>>? = null

    private var sharingSettings: Output<UserProfileUserSettingsSharingSettingsArgs>? = null

    private var tensorBoardAppSettings: Output<UserProfileUserSettingsTensorBoardAppSettingsArgs>? =
        null

    /**
     * @param value The Canvas app settings. See Canvas App Settings below.
     */
    @JvmName("nxkwcolgidxcfbei")
    public suspend
    fun canvasAppSettings(`value`: Output<UserProfileUserSettingsCanvasAppSettingsArgs>) {
        this.canvasAppSettings = value
    }

    /**
     * @param value The execution role ARN for the user.
     */
    @JvmName("qsrpqpsarxqfxkxh")
    public suspend fun executionRole(`value`: Output<String>) {
        this.executionRole = value
    }

    /**
     * @param value The Jupyter server's app settings. See Jupyter Server App Settings below.
     */
    @JvmName("hnrlojoyuvnoqwvm")
    public suspend
    fun jupyterServerAppSettings(`value`: Output<UserProfileUserSettingsJupyterServerAppSettingsArgs>) {
        this.jupyterServerAppSettings = value
    }

    /**
     * @param value The kernel gateway app settings. See Kernel Gateway App Settings below.
     */
    @JvmName("phwlfdkeowiuacwu")
    public suspend
    fun kernelGatewayAppSettings(`value`: Output<UserProfileUserSettingsKernelGatewayAppSettingsArgs>) {
        this.kernelGatewayAppSettings = value
    }

    /**
     * @param value The RSession app settings. See RSession App Settings below.
     */
    @JvmName("xqjldwyhkooilkao")
    public suspend
    fun rSessionAppSettings(`value`: Output<UserProfileUserSettingsRSessionAppSettingsArgs>) {
        this.rSessionAppSettings = value
    }

    /**
     * @param value A collection of settings that configure user interaction with the RStudioServerPro app. See RStudio Server Pro App Settings below.
     */
    @JvmName("qkfglyeadrrquqtw")
    public suspend
    fun rStudioServerProAppSettings(`value`: Output<UserProfileUserSettingsRStudioServerProAppSettingsArgs>) {
        this.rStudioServerProAppSettings = value
    }

    /**
     * @param value The security groups.
     */
    @JvmName("lhndbjkkfsjvxpjy")
    public suspend fun securityGroups(`value`: Output<List<String>>) {
        this.securityGroups = value
    }

    @JvmName("hvfnqikebtmxtmaf")
    public suspend fun securityGroups(vararg values: Output<String>) {
        this.securityGroups = Output.all(values.asList())
    }

    /**
     * @param values The security groups.
     */
    @JvmName("bpgsfqmlcmpkrnxb")
    public suspend fun securityGroups(values: List<Output<String>>) {
        this.securityGroups = Output.all(values)
    }

    /**
     * @param value The sharing settings. See Sharing Settings below.
     */
    @JvmName("xdinhovgybkhoyav")
    public suspend fun sharingSettings(`value`: Output<UserProfileUserSettingsSharingSettingsArgs>) {
        this.sharingSettings = value
    }

    /**
     * @param value The TensorBoard app settings. See TensorBoard App Settings below.
     */
    @JvmName("jutpasruyuuvylkv")
    public suspend
    fun tensorBoardAppSettings(`value`: Output<UserProfileUserSettingsTensorBoardAppSettingsArgs>) {
        this.tensorBoardAppSettings = value
    }

    /**
     * @param value The Canvas app settings. See Canvas App Settings below.
     */
    @JvmName("vuptrnjotcixowad")
    public suspend fun canvasAppSettings(`value`: UserProfileUserSettingsCanvasAppSettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.canvasAppSettings = mapped
    }

    /**
     * @param argument The Canvas app settings. See Canvas App Settings below.
     */
    @JvmName("nywuhmdirbnledsp")
    public suspend
    fun canvasAppSettings(argument: suspend UserProfileUserSettingsCanvasAppSettingsArgsBuilder.() -> Unit) {
        val toBeMapped = UserProfileUserSettingsCanvasAppSettingsArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.canvasAppSettings = mapped
    }

    /**
     * @param value The execution role ARN for the user.
     */
    @JvmName("cgyppnyrsavhjixk")
    public suspend fun executionRole(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.executionRole = mapped
    }

    /**
     * @param value The Jupyter server's app settings. See Jupyter Server App Settings below.
     */
    @JvmName("hpgmwgtdbrygqwde")
    public suspend
    fun jupyterServerAppSettings(`value`: UserProfileUserSettingsJupyterServerAppSettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.jupyterServerAppSettings = mapped
    }

    /**
     * @param argument The Jupyter server's app settings. See Jupyter Server App Settings below.
     */
    @JvmName("eltovpgfomadgcci")
    public suspend
    fun jupyterServerAppSettings(argument: suspend UserProfileUserSettingsJupyterServerAppSettingsArgsBuilder.() -> Unit) {
        val toBeMapped = UserProfileUserSettingsJupyterServerAppSettingsArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.jupyterServerAppSettings = mapped
    }

    /**
     * @param value The kernel gateway app settings. See Kernel Gateway App Settings below.
     */
    @JvmName("qyggxfbwluivwcrv")
    public suspend
    fun kernelGatewayAppSettings(`value`: UserProfileUserSettingsKernelGatewayAppSettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kernelGatewayAppSettings = mapped
    }

    /**
     * @param argument The kernel gateway app settings. See Kernel Gateway App Settings below.
     */
    @JvmName("obxcjthqgfneqfmv")
    public suspend
    fun kernelGatewayAppSettings(argument: suspend UserProfileUserSettingsKernelGatewayAppSettingsArgsBuilder.() -> Unit) {
        val toBeMapped = UserProfileUserSettingsKernelGatewayAppSettingsArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.kernelGatewayAppSettings = mapped
    }

    /**
     * @param value The RSession app settings. See RSession App Settings below.
     */
    @JvmName("sdhlkugqbxlegwxf")
    public suspend fun rSessionAppSettings(`value`: UserProfileUserSettingsRSessionAppSettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.rSessionAppSettings = mapped
    }

    /**
     * @param argument The RSession app settings. See RSession App Settings below.
     */
    @JvmName("wwtmnrcbxibceqjs")
    public suspend
    fun rSessionAppSettings(argument: suspend UserProfileUserSettingsRSessionAppSettingsArgsBuilder.() -> Unit) {
        val toBeMapped = UserProfileUserSettingsRSessionAppSettingsArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.rSessionAppSettings = mapped
    }

    /**
     * @param value A collection of settings that configure user interaction with the RStudioServerPro app. See RStudio Server Pro App Settings below.
     */
    @JvmName("fsckkrdotoklokpj")
    public suspend
    fun rStudioServerProAppSettings(`value`: UserProfileUserSettingsRStudioServerProAppSettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.rStudioServerProAppSettings = mapped
    }

    /**
     * @param argument A collection of settings that configure user interaction with the RStudioServerPro app. See RStudio Server Pro App Settings below.
     */
    @JvmName("cnyhvvmtwflxjcpv")
    public suspend
    fun rStudioServerProAppSettings(argument: suspend UserProfileUserSettingsRStudioServerProAppSettingsArgsBuilder.() -> Unit) {
        val toBeMapped = UserProfileUserSettingsRStudioServerProAppSettingsArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.rStudioServerProAppSettings = mapped
    }

    /**
     * @param value The security groups.
     */
    @JvmName("syittksfftaesycl")
    public suspend fun securityGroups(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.securityGroups = mapped
    }

    /**
     * @param values The security groups.
     */
    @JvmName("kpywvbbmcojmqipc")
    public suspend fun securityGroups(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.securityGroups = mapped
    }

    /**
     * @param value The sharing settings. See Sharing Settings below.
     */
    @JvmName("cxfrhecybmqpyqof")
    public suspend fun sharingSettings(`value`: UserProfileUserSettingsSharingSettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sharingSettings = mapped
    }

    /**
     * @param argument The sharing settings. See Sharing Settings below.
     */
    @JvmName("pokfgbinfistsqja")
    public suspend
    fun sharingSettings(argument: suspend UserProfileUserSettingsSharingSettingsArgsBuilder.() -> Unit) {
        val toBeMapped = UserProfileUserSettingsSharingSettingsArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.sharingSettings = mapped
    }

    /**
     * @param value The TensorBoard app settings. See TensorBoard App Settings below.
     */
    @JvmName("yfotppvijswbdeec")
    public suspend
    fun tensorBoardAppSettings(`value`: UserProfileUserSettingsTensorBoardAppSettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tensorBoardAppSettings = mapped
    }

    /**
     * @param argument The TensorBoard app settings. See TensorBoard App Settings below.
     */
    @JvmName("wolukhfpvxxsiahv")
    public suspend
    fun tensorBoardAppSettings(argument: suspend UserProfileUserSettingsTensorBoardAppSettingsArgsBuilder.() -> Unit) {
        val toBeMapped = UserProfileUserSettingsTensorBoardAppSettingsArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.tensorBoardAppSettings = mapped
    }

    internal fun build(): UserProfileUserSettingsArgs = UserProfileUserSettingsArgs(
        canvasAppSettings = canvasAppSettings,
        executionRole = executionRole ?: throw PulumiNullFieldException("executionRole"),
        jupyterServerAppSettings = jupyterServerAppSettings,
        kernelGatewayAppSettings = kernelGatewayAppSettings,
        rSessionAppSettings = rSessionAppSettings,
        rStudioServerProAppSettings = rStudioServerProAppSettings,
        securityGroups = securityGroups,
        sharingSettings = sharingSettings,
        tensorBoardAppSettings = tensorBoardAppSettings,
    )
}
