@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sagemaker.kotlin.inputs

import com.pulumi.aws.sagemaker.inputs.UserProfileUserSettingsCanvasAppSettingsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property directDeploySettings The model deployment settings for the SageMaker Canvas application. See Direct Deploy Settings below.
 * @property identityProviderOauthSettings The settings for connecting to an external data source with OAuth. See Identity Provider OAuth Settings below.
 * @property kendraSettings The settings for document querying. See Kendra Settings below.
 * @property modelRegisterSettings The model registry settings for the SageMaker Canvas application. See Model Register Settings below.
 * @property timeSeriesForecastingSettings Time series forecast settings for the Canvas app. see Time Series Forecasting Settings below.
 * @property workspaceSettings The workspace settings for the SageMaker Canvas application. See Workspace Settings below.
 */
public data class UserProfileUserSettingsCanvasAppSettingsArgs(
    public val directDeploySettings:
    Output<UserProfileUserSettingsCanvasAppSettingsDirectDeploySettingsArgs>? = null,
    public val identityProviderOauthSettings:
    Output<List<UserProfileUserSettingsCanvasAppSettingsIdentityProviderOauthSettingArgs>>? =
        null,
    public val kendraSettings: Output<UserProfileUserSettingsCanvasAppSettingsKendraSettingsArgs>? =
        null,
    public val modelRegisterSettings:
    Output<UserProfileUserSettingsCanvasAppSettingsModelRegisterSettingsArgs>? = null,
    public val timeSeriesForecastingSettings:
    Output<UserProfileUserSettingsCanvasAppSettingsTimeSeriesForecastingSettingsArgs>? = null,
    public val workspaceSettings:
    Output<UserProfileUserSettingsCanvasAppSettingsWorkspaceSettingsArgs>? = null,
) : ConvertibleToJava<com.pulumi.aws.sagemaker.inputs.UserProfileUserSettingsCanvasAppSettingsArgs> {
    override fun toJava():
        com.pulumi.aws.sagemaker.inputs.UserProfileUserSettingsCanvasAppSettingsArgs =
        com.pulumi.aws.sagemaker.inputs.UserProfileUserSettingsCanvasAppSettingsArgs.builder()
            .directDeploySettings(
                directDeploySettings?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .identityProviderOauthSettings(
                identityProviderOauthSettings?.applyValue({ args0 ->
                    args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .kendraSettings(kendraSettings?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .modelRegisterSettings(
                modelRegisterSettings?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .timeSeriesForecastingSettings(
                timeSeriesForecastingSettings?.applyValue({ args0 ->
                    args0.let({ args0 -> args0.toJava() })
                }),
            )
            .workspaceSettings(
                workspaceSettings?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [UserProfileUserSettingsCanvasAppSettingsArgs].
 */
@PulumiTagMarker
public class UserProfileUserSettingsCanvasAppSettingsArgsBuilder internal constructor() {
    private var directDeploySettings:
        Output<UserProfileUserSettingsCanvasAppSettingsDirectDeploySettingsArgs>? = null

    private var identityProviderOauthSettings:
        Output<List<UserProfileUserSettingsCanvasAppSettingsIdentityProviderOauthSettingArgs>>? = null

    private var kendraSettings: Output<UserProfileUserSettingsCanvasAppSettingsKendraSettingsArgs>? =
        null

    private var modelRegisterSettings:
        Output<UserProfileUserSettingsCanvasAppSettingsModelRegisterSettingsArgs>? = null

    private var timeSeriesForecastingSettings:
        Output<UserProfileUserSettingsCanvasAppSettingsTimeSeriesForecastingSettingsArgs>? = null

    private var workspaceSettings:
        Output<UserProfileUserSettingsCanvasAppSettingsWorkspaceSettingsArgs>? = null

    /**
     * @param value The model deployment settings for the SageMaker Canvas application. See Direct Deploy Settings below.
     */
    @JvmName("gjnjpsslxnpyijvp")
    public suspend
    fun directDeploySettings(`value`: Output<UserProfileUserSettingsCanvasAppSettingsDirectDeploySettingsArgs>) {
        this.directDeploySettings = value
    }

    /**
     * @param value The settings for connecting to an external data source with OAuth. See Identity Provider OAuth Settings below.
     */
    @JvmName("cdgtndcoqgpbtenp")
    public suspend
    fun identityProviderOauthSettings(`value`: Output<List<UserProfileUserSettingsCanvasAppSettingsIdentityProviderOauthSettingArgs>>) {
        this.identityProviderOauthSettings = value
    }

    @JvmName("ykcgmqpkemfgjuym")
    public suspend fun identityProviderOauthSettings(
        vararg
        values: Output<UserProfileUserSettingsCanvasAppSettingsIdentityProviderOauthSettingArgs>,
    ) {
        this.identityProviderOauthSettings = Output.all(values.asList())
    }

    /**
     * @param values The settings for connecting to an external data source with OAuth. See Identity Provider OAuth Settings below.
     */
    @JvmName("obyrxvxpsnctfcry")
    public suspend
    fun identityProviderOauthSettings(values: List<Output<UserProfileUserSettingsCanvasAppSettingsIdentityProviderOauthSettingArgs>>) {
        this.identityProviderOauthSettings = Output.all(values)
    }

    /**
     * @param value The settings for document querying. See Kendra Settings below.
     */
    @JvmName("vggljytlapgukokk")
    public suspend
    fun kendraSettings(`value`: Output<UserProfileUserSettingsCanvasAppSettingsKendraSettingsArgs>) {
        this.kendraSettings = value
    }

    /**
     * @param value The model registry settings for the SageMaker Canvas application. See Model Register Settings below.
     */
    @JvmName("ivwwvjtddenyjpbe")
    public suspend
    fun modelRegisterSettings(`value`: Output<UserProfileUserSettingsCanvasAppSettingsModelRegisterSettingsArgs>) {
        this.modelRegisterSettings = value
    }

    /**
     * @param value Time series forecast settings for the Canvas app. see Time Series Forecasting Settings below.
     */
    @JvmName("wojthnuwyohgmhtt")
    public suspend
    fun timeSeriesForecastingSettings(`value`: Output<UserProfileUserSettingsCanvasAppSettingsTimeSeriesForecastingSettingsArgs>) {
        this.timeSeriesForecastingSettings = value
    }

    /**
     * @param value The workspace settings for the SageMaker Canvas application. See Workspace Settings below.
     */
    @JvmName("cckkhimnuorvlxlv")
    public suspend
    fun workspaceSettings(`value`: Output<UserProfileUserSettingsCanvasAppSettingsWorkspaceSettingsArgs>) {
        this.workspaceSettings = value
    }

    /**
     * @param value The model deployment settings for the SageMaker Canvas application. See Direct Deploy Settings below.
     */
    @JvmName("ivivnuwoknlrhnix")
    public suspend
    fun directDeploySettings(`value`: UserProfileUserSettingsCanvasAppSettingsDirectDeploySettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.directDeploySettings = mapped
    }

    /**
     * @param argument The model deployment settings for the SageMaker Canvas application. See Direct Deploy Settings below.
     */
    @JvmName("saemouxldxldkief")
    public suspend
    fun directDeploySettings(argument: suspend UserProfileUserSettingsCanvasAppSettingsDirectDeploySettingsArgsBuilder.() -> Unit) {
        val toBeMapped =
            UserProfileUserSettingsCanvasAppSettingsDirectDeploySettingsArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.directDeploySettings = mapped
    }

    /**
     * @param value The settings for connecting to an external data source with OAuth. See Identity Provider OAuth Settings below.
     */
    @JvmName("uuqsbqfcteimmjuf")
    public suspend
    fun identityProviderOauthSettings(`value`: List<UserProfileUserSettingsCanvasAppSettingsIdentityProviderOauthSettingArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.identityProviderOauthSettings = mapped
    }

    /**
     * @param argument The settings for connecting to an external data source with OAuth. See Identity Provider OAuth Settings below.
     */
    @JvmName("djupnfaguwggapxa")
    public suspend
    fun identityProviderOauthSettings(argument: List<suspend UserProfileUserSettingsCanvasAppSettingsIdentityProviderOauthSettingArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            UserProfileUserSettingsCanvasAppSettingsIdentityProviderOauthSettingArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.identityProviderOauthSettings = mapped
    }

    /**
     * @param argument The settings for connecting to an external data source with OAuth. See Identity Provider OAuth Settings below.
     */
    @JvmName("uudkscpufjpgpvjy")
    public suspend fun identityProviderOauthSettings(
        vararg
        argument: suspend UserProfileUserSettingsCanvasAppSettingsIdentityProviderOauthSettingArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            UserProfileUserSettingsCanvasAppSettingsIdentityProviderOauthSettingArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.identityProviderOauthSettings = mapped
    }

    /**
     * @param argument The settings for connecting to an external data source with OAuth. See Identity Provider OAuth Settings below.
     */
    @JvmName("kupuwpvhauyhayea")
    public suspend
    fun identityProviderOauthSettings(argument: suspend UserProfileUserSettingsCanvasAppSettingsIdentityProviderOauthSettingArgsBuilder.() -> Unit) {
        val toBeMapped =
            listOf(
                UserProfileUserSettingsCanvasAppSettingsIdentityProviderOauthSettingArgsBuilder().applySuspend
                    { argument() }.build(),
            )
        val mapped = of(toBeMapped)
        this.identityProviderOauthSettings = mapped
    }

    /**
     * @param values The settings for connecting to an external data source with OAuth. See Identity Provider OAuth Settings below.
     */
    @JvmName("ogcjcrsebxrivlkr")
    public suspend fun identityProviderOauthSettings(
        vararg
        values: UserProfileUserSettingsCanvasAppSettingsIdentityProviderOauthSettingArgs,
    ) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.identityProviderOauthSettings = mapped
    }

    /**
     * @param value The settings for document querying. See Kendra Settings below.
     */
    @JvmName("xwgfjhabpimnrfru")
    public suspend
    fun kendraSettings(`value`: UserProfileUserSettingsCanvasAppSettingsKendraSettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kendraSettings = mapped
    }

    /**
     * @param argument The settings for document querying. See Kendra Settings below.
     */
    @JvmName("bpnpraupmsfepnlc")
    public suspend
    fun kendraSettings(argument: suspend UserProfileUserSettingsCanvasAppSettingsKendraSettingsArgsBuilder.() -> Unit) {
        val toBeMapped =
            UserProfileUserSettingsCanvasAppSettingsKendraSettingsArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.kendraSettings = mapped
    }

    /**
     * @param value The model registry settings for the SageMaker Canvas application. See Model Register Settings below.
     */
    @JvmName("nxfowfajswssdvpc")
    public suspend
    fun modelRegisterSettings(`value`: UserProfileUserSettingsCanvasAppSettingsModelRegisterSettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.modelRegisterSettings = mapped
    }

    /**
     * @param argument The model registry settings for the SageMaker Canvas application. See Model Register Settings below.
     */
    @JvmName("bckqvqxunhgbmulk")
    public suspend
    fun modelRegisterSettings(argument: suspend UserProfileUserSettingsCanvasAppSettingsModelRegisterSettingsArgsBuilder.() -> Unit) {
        val toBeMapped =
            UserProfileUserSettingsCanvasAppSettingsModelRegisterSettingsArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.modelRegisterSettings = mapped
    }

    /**
     * @param value Time series forecast settings for the Canvas app. see Time Series Forecasting Settings below.
     */
    @JvmName("yvepnwsqqqmesafq")
    public suspend
    fun timeSeriesForecastingSettings(`value`: UserProfileUserSettingsCanvasAppSettingsTimeSeriesForecastingSettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.timeSeriesForecastingSettings = mapped
    }

    /**
     * @param argument Time series forecast settings for the Canvas app. see Time Series Forecasting Settings below.
     */
    @JvmName("efqeabeqkqddjpmk")
    public suspend
    fun timeSeriesForecastingSettings(argument: suspend UserProfileUserSettingsCanvasAppSettingsTimeSeriesForecastingSettingsArgsBuilder.() -> Unit) {
        val toBeMapped =
            UserProfileUserSettingsCanvasAppSettingsTimeSeriesForecastingSettingsArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.timeSeriesForecastingSettings = mapped
    }

    /**
     * @param value The workspace settings for the SageMaker Canvas application. See Workspace Settings below.
     */
    @JvmName("llswuhfkaqeiintq")
    public suspend
    fun workspaceSettings(`value`: UserProfileUserSettingsCanvasAppSettingsWorkspaceSettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.workspaceSettings = mapped
    }

    /**
     * @param argument The workspace settings for the SageMaker Canvas application. See Workspace Settings below.
     */
    @JvmName("icbjgcwaflfgxbeh")
    public suspend
    fun workspaceSettings(argument: suspend UserProfileUserSettingsCanvasAppSettingsWorkspaceSettingsArgsBuilder.() -> Unit) {
        val toBeMapped =
            UserProfileUserSettingsCanvasAppSettingsWorkspaceSettingsArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.workspaceSettings = mapped
    }

    internal fun build(): UserProfileUserSettingsCanvasAppSettingsArgs =
        UserProfileUserSettingsCanvasAppSettingsArgs(
            directDeploySettings = directDeploySettings,
            identityProviderOauthSettings = identityProviderOauthSettings,
            kendraSettings = kendraSettings,
            modelRegisterSettings = modelRegisterSettings,
            timeSeriesForecastingSettings = timeSeriesForecastingSettings,
            workspaceSettings = workspaceSettings,
        )
}
