@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sagemaker.kotlin.inputs

import com.pulumi.aws.sagemaker.inputs.UserProfileUserSettingsCanvasAppSettingsIdentityProviderOauthSettingArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property dataSourceName The name of the data source that you're connecting to. Canvas currently supports OAuth for Snowflake and Salesforce Data Cloud. Valid values are `SalesforceGenie` and `Snowflake`.
 * @property secretArn The ARN of an Amazon Web Services Secrets Manager secret that stores the credentials from your identity provider, such as the client ID and secret, authorization URL, and token URL.
 * @property status Describes whether OAuth for a data source is enabled or disabled in the Canvas application. Valid values are `ENABLED` and `DISABLED`.
 */
public data class UserProfileUserSettingsCanvasAppSettingsIdentityProviderOauthSettingArgs(
    public val dataSourceName: Output<String>? = null,
    public val secretArn: Output<String>,
    public val status: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.sagemaker.inputs.UserProfileUserSettingsCanvasAppSettingsIdentityProviderOauthSettingArgs> {
    override fun toJava():
        com.pulumi.aws.sagemaker.inputs.UserProfileUserSettingsCanvasAppSettingsIdentityProviderOauthSettingArgs =
        com.pulumi.aws.sagemaker.inputs.UserProfileUserSettingsCanvasAppSettingsIdentityProviderOauthSettingArgs.builder()
            .dataSourceName(dataSourceName?.applyValue({ args0 -> args0 }))
            .secretArn(secretArn.applyValue({ args0 -> args0 }))
            .status(status?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [UserProfileUserSettingsCanvasAppSettingsIdentityProviderOauthSettingArgs].
 */
@PulumiTagMarker
public class UserProfileUserSettingsCanvasAppSettingsIdentityProviderOauthSettingArgsBuilder
internal constructor() {
    private var dataSourceName: Output<String>? = null

    private var secretArn: Output<String>? = null

    private var status: Output<String>? = null

    /**
     * @param value The name of the data source that you're connecting to. Canvas currently supports OAuth for Snowflake and Salesforce Data Cloud. Valid values are `SalesforceGenie` and `Snowflake`.
     */
    @JvmName("uipyojwijlikcchn")
    public suspend fun dataSourceName(`value`: Output<String>) {
        this.dataSourceName = value
    }

    /**
     * @param value The ARN of an Amazon Web Services Secrets Manager secret that stores the credentials from your identity provider, such as the client ID and secret, authorization URL, and token URL.
     */
    @JvmName("kovpsgpwxeinafgw")
    public suspend fun secretArn(`value`: Output<String>) {
        this.secretArn = value
    }

    /**
     * @param value Describes whether OAuth for a data source is enabled or disabled in the Canvas application. Valid values are `ENABLED` and `DISABLED`.
     */
    @JvmName("eaangyjqrjdruitj")
    public suspend fun status(`value`: Output<String>) {
        this.status = value
    }

    /**
     * @param value The name of the data source that you're connecting to. Canvas currently supports OAuth for Snowflake and Salesforce Data Cloud. Valid values are `SalesforceGenie` and `Snowflake`.
     */
    @JvmName("cxkeqjomgmkfahup")
    public suspend fun dataSourceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dataSourceName = mapped
    }

    /**
     * @param value The ARN of an Amazon Web Services Secrets Manager secret that stores the credentials from your identity provider, such as the client ID and secret, authorization URL, and token URL.
     */
    @JvmName("iqfovxaeccgaeteb")
    public suspend fun secretArn(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.secretArn = mapped
    }

    /**
     * @param value Describes whether OAuth for a data source is enabled or disabled in the Canvas application. Valid values are `ENABLED` and `DISABLED`.
     */
    @JvmName("ivixqyuplcifkmex")
    public suspend fun status(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.status = mapped
    }

    internal fun build(): UserProfileUserSettingsCanvasAppSettingsIdentityProviderOauthSettingArgs =
        UserProfileUserSettingsCanvasAppSettingsIdentityProviderOauthSettingArgs(
            dataSourceName = dataSourceName,
            secretArn = secretArn ?: throw PulumiNullFieldException("secretArn"),
            status = status,
        )
}
