@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sagemaker.kotlin.inputs

import com.pulumi.aws.sagemaker.inputs.UserProfileUserSettingsRSessionAppSettingsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property customImages A list of custom SageMaker images that are configured to run as a KernelGateway app. see Custom Image below.
 * @property defaultResourceSpec The default instance type and the Amazon Resource Name (ARN) of the SageMaker image created on the instance. see Default Resource Spec below.
 */
public data class UserProfileUserSettingsRSessionAppSettingsArgs(
    public val customImages: Output<List<UserProfileUserSettingsRSessionAppSettingsCustomImageArgs>>? =
        null,
    public val defaultResourceSpec:
    Output<UserProfileUserSettingsRSessionAppSettingsDefaultResourceSpecArgs>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.sagemaker.inputs.UserProfileUserSettingsRSessionAppSettingsArgs> {
    override fun toJava():
        com.pulumi.aws.sagemaker.inputs.UserProfileUserSettingsRSessionAppSettingsArgs =
        com.pulumi.aws.sagemaker.inputs.UserProfileUserSettingsRSessionAppSettingsArgs.builder()
            .customImages(
                customImages?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .defaultResourceSpec(
                defaultResourceSpec?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [UserProfileUserSettingsRSessionAppSettingsArgs].
 */
@PulumiTagMarker
public class UserProfileUserSettingsRSessionAppSettingsArgsBuilder internal constructor() {
    private var customImages: Output<List<UserProfileUserSettingsRSessionAppSettingsCustomImageArgs>>? =
        null

    private var defaultResourceSpec:
        Output<UserProfileUserSettingsRSessionAppSettingsDefaultResourceSpecArgs>? = null

    /**
     * @param value A list of custom SageMaker images that are configured to run as a KernelGateway app. see Custom Image below.
     */
    @JvmName("wplobasuijleacnw")
    public suspend
    fun customImages(`value`: Output<List<UserProfileUserSettingsRSessionAppSettingsCustomImageArgs>>) {
        this.customImages = value
    }

    @JvmName("moelccernwmeruoe")
    public suspend fun customImages(
        vararg
        values: Output<UserProfileUserSettingsRSessionAppSettingsCustomImageArgs>,
    ) {
        this.customImages = Output.all(values.asList())
    }

    /**
     * @param values A list of custom SageMaker images that are configured to run as a KernelGateway app. see Custom Image below.
     */
    @JvmName("pnmybhntachvkciv")
    public suspend
    fun customImages(values: List<Output<UserProfileUserSettingsRSessionAppSettingsCustomImageArgs>>) {
        this.customImages = Output.all(values)
    }

    /**
     * @param value The default instance type and the Amazon Resource Name (ARN) of the SageMaker image created on the instance. see Default Resource Spec below.
     */
    @JvmName("ajqliydvpxpwmyqh")
    public suspend
    fun defaultResourceSpec(`value`: Output<UserProfileUserSettingsRSessionAppSettingsDefaultResourceSpecArgs>) {
        this.defaultResourceSpec = value
    }

    /**
     * @param value A list of custom SageMaker images that are configured to run as a KernelGateway app. see Custom Image below.
     */
    @JvmName("gdinsytqjhcysebj")
    public suspend
    fun customImages(`value`: List<UserProfileUserSettingsRSessionAppSettingsCustomImageArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.customImages = mapped
    }

    /**
     * @param argument A list of custom SageMaker images that are configured to run as a KernelGateway app. see Custom Image below.
     */
    @JvmName("juttgsyllvfunulh")
    public suspend
    fun customImages(argument: List<suspend UserProfileUserSettingsRSessionAppSettingsCustomImageArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            UserProfileUserSettingsRSessionAppSettingsCustomImageArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.customImages = mapped
    }

    /**
     * @param argument A list of custom SageMaker images that are configured to run as a KernelGateway app. see Custom Image below.
     */
    @JvmName("cupvivsnkrevhexc")
    public suspend fun customImages(
        vararg
        argument: suspend UserProfileUserSettingsRSessionAppSettingsCustomImageArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            UserProfileUserSettingsRSessionAppSettingsCustomImageArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.customImages = mapped
    }

    /**
     * @param argument A list of custom SageMaker images that are configured to run as a KernelGateway app. see Custom Image below.
     */
    @JvmName("jowebgwrmwvduohc")
    public suspend
    fun customImages(argument: suspend UserProfileUserSettingsRSessionAppSettingsCustomImageArgsBuilder.() -> Unit) {
        val toBeMapped =
            listOf(
                UserProfileUserSettingsRSessionAppSettingsCustomImageArgsBuilder().applySuspend {
                    argument()
                }.build(),
            )
        val mapped = of(toBeMapped)
        this.customImages = mapped
    }

    /**
     * @param values A list of custom SageMaker images that are configured to run as a KernelGateway app. see Custom Image below.
     */
    @JvmName("crseuyouevewcalw")
    public suspend fun customImages(
        vararg
        values: UserProfileUserSettingsRSessionAppSettingsCustomImageArgs,
    ) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.customImages = mapped
    }

    /**
     * @param value The default instance type and the Amazon Resource Name (ARN) of the SageMaker image created on the instance. see Default Resource Spec below.
     */
    @JvmName("luadjhsnjcepdwuw")
    public suspend
    fun defaultResourceSpec(`value`: UserProfileUserSettingsRSessionAppSettingsDefaultResourceSpecArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.defaultResourceSpec = mapped
    }

    /**
     * @param argument The default instance type and the Amazon Resource Name (ARN) of the SageMaker image created on the instance. see Default Resource Spec below.
     */
    @JvmName("hviipjxwijhwgjjr")
    public suspend
    fun defaultResourceSpec(argument: suspend UserProfileUserSettingsRSessionAppSettingsDefaultResourceSpecArgsBuilder.() -> Unit) {
        val toBeMapped =
            UserProfileUserSettingsRSessionAppSettingsDefaultResourceSpecArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.defaultResourceSpec = mapped
    }

    internal fun build(): UserProfileUserSettingsRSessionAppSettingsArgs =
        UserProfileUserSettingsRSessionAppSettingsArgs(
            customImages = customImages,
            defaultResourceSpec = defaultResourceSpec,
        )
}
