@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sagemaker.kotlin.inputs

import com.pulumi.aws.sagemaker.inputs.WorkforceWorkforceVpcConfigArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property securityGroupIds The VPC security group IDs. The security groups must be for the same VPC as specified in the subnet.
 * @property subnets The ID of the subnets in the VPC that you want to connect.
 * @property vpcEndpointId
 * @property vpcId The ID of the VPC that the workforce uses for communication.
 */
public data class WorkforceWorkforceVpcConfigArgs(
    public val securityGroupIds: Output<List<String>>? = null,
    public val subnets: Output<List<String>>? = null,
    public val vpcEndpointId: Output<String>? = null,
    public val vpcId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.sagemaker.inputs.WorkforceWorkforceVpcConfigArgs> {
    override fun toJava(): com.pulumi.aws.sagemaker.inputs.WorkforceWorkforceVpcConfigArgs =
        com.pulumi.aws.sagemaker.inputs.WorkforceWorkforceVpcConfigArgs.builder()
            .securityGroupIds(securityGroupIds?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .subnets(subnets?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .vpcEndpointId(vpcEndpointId?.applyValue({ args0 -> args0 }))
            .vpcId(vpcId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [WorkforceWorkforceVpcConfigArgs].
 */
@PulumiTagMarker
public class WorkforceWorkforceVpcConfigArgsBuilder internal constructor() {
    private var securityGroupIds: Output<List<String>>? = null

    private var subnets: Output<List<String>>? = null

    private var vpcEndpointId: Output<String>? = null

    private var vpcId: Output<String>? = null

    /**
     * @param value The VPC security group IDs. The security groups must be for the same VPC as specified in the subnet.
     */
    @JvmName("xotyqfpvtsjvxahr")
    public suspend fun securityGroupIds(`value`: Output<List<String>>) {
        this.securityGroupIds = value
    }

    @JvmName("hbjhyxiqenvxivcb")
    public suspend fun securityGroupIds(vararg values: Output<String>) {
        this.securityGroupIds = Output.all(values.asList())
    }

    /**
     * @param values The VPC security group IDs. The security groups must be for the same VPC as specified in the subnet.
     */
    @JvmName("hnixlqvirnisxbfd")
    public suspend fun securityGroupIds(values: List<Output<String>>) {
        this.securityGroupIds = Output.all(values)
    }

    /**
     * @param value The ID of the subnets in the VPC that you want to connect.
     */
    @JvmName("qbtenxicusskjsxu")
    public suspend fun subnets(`value`: Output<List<String>>) {
        this.subnets = value
    }

    @JvmName("dfvbokytibdhhfmy")
    public suspend fun subnets(vararg values: Output<String>) {
        this.subnets = Output.all(values.asList())
    }

    /**
     * @param values The ID of the subnets in the VPC that you want to connect.
     */
    @JvmName("kmsmqvtdjjswocyl")
    public suspend fun subnets(values: List<Output<String>>) {
        this.subnets = Output.all(values)
    }

    /**
     * @param value
     */
    @JvmName("haneafbbbqtpfmkm")
    public suspend fun vpcEndpointId(`value`: Output<String>) {
        this.vpcEndpointId = value
    }

    /**
     * @param value The ID of the VPC that the workforce uses for communication.
     */
    @JvmName("hkoljknbnfbidqgj")
    public suspend fun vpcId(`value`: Output<String>) {
        this.vpcId = value
    }

    /**
     * @param value The VPC security group IDs. The security groups must be for the same VPC as specified in the subnet.
     */
    @JvmName("mibqnnyecwnyllen")
    public suspend fun securityGroupIds(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.securityGroupIds = mapped
    }

    /**
     * @param values The VPC security group IDs. The security groups must be for the same VPC as specified in the subnet.
     */
    @JvmName("npfiiiqrowspcijg")
    public suspend fun securityGroupIds(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.securityGroupIds = mapped
    }

    /**
     * @param value The ID of the subnets in the VPC that you want to connect.
     */
    @JvmName("ixvscsfelvdmbmrq")
    public suspend fun subnets(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.subnets = mapped
    }

    /**
     * @param values The ID of the subnets in the VPC that you want to connect.
     */
    @JvmName("suossxsbcopyjbus")
    public suspend fun subnets(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.subnets = mapped
    }

    /**
     * @param value
     */
    @JvmName("awvoyrsbklitykgp")
    public suspend fun vpcEndpointId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vpcEndpointId = mapped
    }

    /**
     * @param value The ID of the VPC that the workforce uses for communication.
     */
    @JvmName("pdemmhnxlqmdybmv")
    public suspend fun vpcId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vpcId = mapped
    }

    internal fun build(): WorkforceWorkforceVpcConfigArgs = WorkforceWorkforceVpcConfigArgs(
        securityGroupIds = securityGroupIds,
        subnets = subnets,
        vpcEndpointId = vpcEndpointId,
        vpcId = vpcId,
    )
}
