@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sagemaker.kotlin.inputs

import com.pulumi.aws.sagemaker.inputs.WorkteamMemberDefinitionCognitoMemberDefinitionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property clientId An identifier for an application client. You must create the app client ID using Amazon Cognito.
 * @property userGroup An identifier for a user group.
 * @property userPool An identifier for a user pool. The user pool must be in the same region as the service that you are calling.
 */
public data class WorkteamMemberDefinitionCognitoMemberDefinitionArgs(
    public val clientId: Output<String>,
    public val userGroup: Output<String>,
    public val userPool: Output<String>,
) :
    ConvertibleToJava<com.pulumi.aws.sagemaker.inputs.WorkteamMemberDefinitionCognitoMemberDefinitionArgs> {
    override fun toJava():
        com.pulumi.aws.sagemaker.inputs.WorkteamMemberDefinitionCognitoMemberDefinitionArgs =
        com.pulumi.aws.sagemaker.inputs.WorkteamMemberDefinitionCognitoMemberDefinitionArgs.builder()
            .clientId(clientId.applyValue({ args0 -> args0 }))
            .userGroup(userGroup.applyValue({ args0 -> args0 }))
            .userPool(userPool.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [WorkteamMemberDefinitionCognitoMemberDefinitionArgs].
 */
@PulumiTagMarker
public class WorkteamMemberDefinitionCognitoMemberDefinitionArgsBuilder internal constructor() {
    private var clientId: Output<String>? = null

    private var userGroup: Output<String>? = null

    private var userPool: Output<String>? = null

    /**
     * @param value An identifier for an application client. You must create the app client ID using Amazon Cognito.
     */
    @JvmName("ubmioacrbabqfaog")
    public suspend fun clientId(`value`: Output<String>) {
        this.clientId = value
    }

    /**
     * @param value An identifier for a user group.
     */
    @JvmName("goxnychwgprupuvm")
    public suspend fun userGroup(`value`: Output<String>) {
        this.userGroup = value
    }

    /**
     * @param value An identifier for a user pool. The user pool must be in the same region as the service that you are calling.
     */
    @JvmName("gaoydtwsmbmbssyd")
    public suspend fun userPool(`value`: Output<String>) {
        this.userPool = value
    }

    /**
     * @param value An identifier for an application client. You must create the app client ID using Amazon Cognito.
     */
    @JvmName("aggmauubgymxdqrr")
    public suspend fun clientId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.clientId = mapped
    }

    /**
     * @param value An identifier for a user group.
     */
    @JvmName("xnjbeqyhcftrblss")
    public suspend fun userGroup(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.userGroup = mapped
    }

    /**
     * @param value An identifier for a user pool. The user pool must be in the same region as the service that you are calling.
     */
    @JvmName("bouatjrrijibwrmf")
    public suspend fun userPool(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.userPool = mapped
    }

    internal fun build(): WorkteamMemberDefinitionCognitoMemberDefinitionArgs =
        WorkteamMemberDefinitionCognitoMemberDefinitionArgs(
            clientId = clientId ?: throw PulumiNullFieldException("clientId"),
            userGroup = userGroup ?: throw PulumiNullFieldException("userGroup"),
            userPool = userPool ?: throw PulumiNullFieldException("userPool"),
        )
}
