@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sagemaker.kotlin.inputs

import com.pulumi.aws.sagemaker.inputs.WorkteamMemberDefinitionOidcMemberDefinitionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property groups A list of comma separated strings that identifies user groups in your OIDC IdP. Each user group is made up of a group of private workers.
 */
public data class WorkteamMemberDefinitionOidcMemberDefinitionArgs(
    public val groups: Output<List<String>>,
) :
    ConvertibleToJava<com.pulumi.aws.sagemaker.inputs.WorkteamMemberDefinitionOidcMemberDefinitionArgs> {
    override fun toJava():
        com.pulumi.aws.sagemaker.inputs.WorkteamMemberDefinitionOidcMemberDefinitionArgs =
        com.pulumi.aws.sagemaker.inputs.WorkteamMemberDefinitionOidcMemberDefinitionArgs.builder()
            .groups(groups.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [WorkteamMemberDefinitionOidcMemberDefinitionArgs].
 */
@PulumiTagMarker
public class WorkteamMemberDefinitionOidcMemberDefinitionArgsBuilder internal constructor() {
    private var groups: Output<List<String>>? = null

    /**
     * @param value A list of comma separated strings that identifies user groups in your OIDC IdP. Each user group is made up of a group of private workers.
     */
    @JvmName("klcqbljqxmnuggmh")
    public suspend fun groups(`value`: Output<List<String>>) {
        this.groups = value
    }

    @JvmName("xegmqjyxxqkyrmjg")
    public suspend fun groups(vararg values: Output<String>) {
        this.groups = Output.all(values.asList())
    }

    /**
     * @param values A list of comma separated strings that identifies user groups in your OIDC IdP. Each user group is made up of a group of private workers.
     */
    @JvmName("mkkytgpramlntbde")
    public suspend fun groups(values: List<Output<String>>) {
        this.groups = Output.all(values)
    }

    /**
     * @param value A list of comma separated strings that identifies user groups in your OIDC IdP. Each user group is made up of a group of private workers.
     */
    @JvmName("hhajvlioweonvgtv")
    public suspend fun groups(`value`: List<String>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.groups = mapped
    }

    /**
     * @param values A list of comma separated strings that identifies user groups in your OIDC IdP. Each user group is made up of a group of private workers.
     */
    @JvmName("dgsjphlddorssrca")
    public suspend fun groups(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.groups = mapped
    }

    internal fun build(): WorkteamMemberDefinitionOidcMemberDefinitionArgs =
        WorkteamMemberDefinitionOidcMemberDefinitionArgs(
            groups = groups ?: throw PulumiNullFieldException("groups"),
        )
}
