@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.sagemaker.kotlin.inputs

import com.pulumi.aws.sagemaker.inputs.WorkteamNotificationConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property notificationTopicArn The ARN for the SNS topic to which notifications should be published.
 */
public data class WorkteamNotificationConfigurationArgs(
    public val notificationTopicArn: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.sagemaker.inputs.WorkteamNotificationConfigurationArgs> {
    override fun toJava(): com.pulumi.aws.sagemaker.inputs.WorkteamNotificationConfigurationArgs =
        com.pulumi.aws.sagemaker.inputs.WorkteamNotificationConfigurationArgs.builder()
            .notificationTopicArn(notificationTopicArn?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [WorkteamNotificationConfigurationArgs].
 */
@PulumiTagMarker
public class WorkteamNotificationConfigurationArgsBuilder internal constructor() {
    private var notificationTopicArn: Output<String>? = null

    /**
     * @param value The ARN for the SNS topic to which notifications should be published.
     */
    @JvmName("yjyrjqdgmtwbuajp")
    public suspend fun notificationTopicArn(`value`: Output<String>) {
        this.notificationTopicArn = value
    }

    /**
     * @param value The ARN for the SNS topic to which notifications should be published.
     */
    @JvmName("nptwblrlvvrciurk")
    public suspend fun notificationTopicArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.notificationTopicArn = mapped
    }

    internal fun build(): WorkteamNotificationConfigurationArgs =
        WorkteamNotificationConfigurationArgs(
            notificationTopicArn = notificationTopicArn,
        )
}
